# $Date: 1994/12/20 21:24:21 $  $Author: olli $  $Revision: 1.3 $ #

proc()
begin

# default order of series expansion #
ORDER:= 6:

#++
taylor -- expand expression into taylor series

taylor(f, eq, o)

f  - expression to expand
eq - equation or identifier
o  - order, positive integer (optional)

taylor(f, x=p, o) expands f according to the variable x at point p
into a taylor series of order o.

taylor(f, x, o) expands f at x=0.

The order o may be missing, in this case the global variable ORDER
determines the order of expansion. The default value of ORDER is 6.
++#

taylor:= proc(_f_, eq, o)
    local i, x, d, fx, s, t;
begin
    if args(0) = 2 then o:= ORDER end_if;

    if testargs() then
	if args(0) <> 2 and args(0) <> 3 then error("wrong no of args") end_if;
	if type(eq) = "_equal" then
	    if domtype(op(eq,1)) <> DOM_IDENT then
		error("invalid variable")
	    end_if
	else
	    if domtype(eq) <> DOM_IDENT then
		error("invalid variable")
	    end_if
	end_if;
	if domtype(o) <> DOM_INT then
	    error("invalid order")
	end_if;
	if o < 1 then
	    error("invalid order")
	end_if;
    end_if;

    if domtype(eq) = DOM_IDENT then
	x:= eq;
	eq:= (x = 0);
	d:= x;
    else
	x:= op(eq,1);
	d:= op(eq,1) - op(eq,2);
    end_if;

    if traperror((

	# compute series terms si, the terms are collected in a list to
	  avoid repeated evaluation of '+'. #

	fx:= subs(_f_, eq);
	s:= [ context(fx) ];
	t:= 1;
	for i from 1 to o-1 do
	    _f_:= diff(_f_, x);
	    t:= t * d / i;
            fx:= subs(_f_, eq);
	    s:= append(s, t * context(fx));
	end_for;

	# is there a reminder? #
	if diff(_f_, x) <> 0 then s:= append(s, O(x^o)) end_if;
	s:= _plus(op(s));

    )) <> 0 then
	error("taylor series expansion not possible")
    end_if;
    s
end_proc:

end_proc():

# end of file #
