
#++
read -- read file

read(name)
read(fd)

name - file name (string)
fd   - file descriptor (integer)
++#

read:= fun((
    if args(0) <> 1 then error("Wrong no of args") end_if;
    case domtype(args(1))
    of DOM_INT do
	return(fread(args(1)));
    of DOM_STRING do
	if args(1) = "" then
	    if sysname() = "MACOS" then
	        return(fread(""))
	    end_if
	end_if;
	break;
    otherwise error("Illegal argument");
    end_case;

    # open file by local proc to avoid name conflicts #
    fread(proc(nam)
	name read;
	local f, p, isf;
    begin
	isf:= bool(substring(nam,0,1) <> stdlib::PathSep);
	# try to open with READ_PATH #
	if domtype(READ_PATH) <> DOM_IDENT then
	    for p in READ_PATH do
		if isf then
		    if substring(p,strlen(p)-1,1) <> stdlib::PathSep then
			p:= p.stdlib::PathSep
		    end_if
		end_if;
		f:= fopen(p.nam);
		if f <> FAIL then fclose(f); return(p.nam) end_if
	    end_for;
	end_if;

	# try to open with direct path #
	f:= fopen(nam);
	if f <> FAIL then fclose(f); return(nam) end_if;

	# try to open with LIB_PATH #
	for p in LIB_PATH do
	    if isf then
		if substring(p,strlen(p)-1,1) <> stdlib::PathSep then
		    p:= p.stdlib::PathSep
		end_if
	    end_if;
	    f:= fopen(p.nam);
	    if f <> FAIL then fclose(f); return(p.nam) end_if
	end_for;

	error("Could not open \"".nam."\"");
    end_proc(args(1)));
)):

