#++
powermod -- power modulus a number or polynomial

powermod(p, n, m)

p - integer or polynomial
n - integer
m - integer or univariate polynomial

powermod(p, n, m) returns p^n mod m where p and m may be integers or 
univariate polynomials.
++#

powermod:= fun((
    if args(0) <> 3 then error("wrong no of args") end_if;
    case domtype(args(3))
    of DOM_INT do
    	case domtype(args(1))
    	of DOM_INT do
    	of DOM_RAT do
    	    stdlib::powermod(args());
    	    break;
    	of DOM_POLY do
    	    poly(poly(args(1), IntMod(args(3)))^args(2), op(args(1),2..3));
    	    break;
    	otherwise	
    	    expr(poly(args(1), IntMod(args(3)))^args(2));
    	end_case;
    	break;
    of DOM_POLY do
    	if testargs() then
    	    if nops(op(args(3),2)) <> 1 then
    	    	error("multivariate polynomials not allowed")
    	    end_if;
    	    if domtype(args(2)) <> DOM_INT then
    	    	error("illegal power")
    	    end_if;
    	end_if;
    	if domtype(args(1)) <> DOM_POLY then
    	    if args(1) = FAIL then
    	        FAIL
    	    else
    	    	expr(powermod(poly(args(1), op(args(3),2..3)), args(2), args(3)))
    	    end_if
    	elif op(args(1),2..3) = op(args(3),2..3) then
    	    case args(2)
    	    of 0 do return(args(1)^0);
    	    of 1 do return(divide(args(1), args(3), Rem));
    	    end_case;
    	    faclib::powermod_poly(args())
    	elif op(args(1),3) = op(args(3),3) then
    	    poly(powermod(poly(args(1), op(args(3),2..3)), args(2), args(3)),
    	         op(args(1),2..3))
    	else
    	    error("polynomial types differ")
    	end_if;
    	break;
    of FAIL do
    	FAIL;
    	break;
    otherwise
    	powermod(args(1), args(2), poly(args(3)))
    end_case)):

