# $Date: 1995/04/10 15:45:41 $  $Author: kg $  $Revision: 1.10 $ #
# kg, 24.09.92 #
#++
loadlib -- load library file(s)

loadlib(lib)

lib - library name (string)

loadlib() is an utility routine to define all files related to the MuPAD
library "lib". loadlib returns TRUE if the library was loaded and FALSE
if it was allready loaded before (a library is not loaded twice).

loadlib("lib") builds the "lib-file" name from the string "lib" and reads in
that file. The "lib-file" in turn contains commands to define functions
related to that MuPAD library. A function solve() in the "lib" library
file LIB/solve.mu is defined as follows:

	solve:= loadproc(solve, pathname("LIB")."solve.mu"):

This MuPAD command defines solve such that a call of solve reads in the
file "LIB/solve.mu" and then calls solve "really".

The "lib-file" must be "BIN/lib.mb" or "lib.mu" in a subdirectory
"LIBFILES". Note that the variables LIB_PATH is used for searching for the
file.
++#

loadlib := proc(lib)
    local path, f;
begin
    if args(0) <> 1 then
	error("wrong number of parameters")
    end_if;
    if domtype(lib) <> DOM_STRING then
	error("parameter must be a string")
    end_if;
    
    if stdlib::LoadlibState = FAIL then
        stdlib::LoadlibState:= table()
    end_if;
    
    if stdlib::LoadlibState[lib] = TRUE then
	FALSE
    else
	stdlib::LoadlibState[lib]:= FALSE;

	# read using LIB_PATH #
	for path in LIB_PATH do
	    # first try to open binary file #
	    f:= fopen(path.pathname("LIBFILES","BIN").lib.".mb");
	    if f = FAIL then
		# try to open text file #
		f:= fopen(path.pathname("LIBFILES").lib.".mu");
	    end_if;
	    if f <> FAIL then break end_if
    	end_for;

	if f = FAIL then
	    error("can't read library file ".pathname("LIBFILES").lib.".mu")
	end_if;

	fread(f);
	fclose(f);
    	stdlib::LoadlibState[lib]:= TRUE;
	TRUE
    end_if
end_proc:

# end of file #
