# $Date: 1995/02/22 13:02:53 $  $Author: kg $  $Revision: 1.6 $ #
# kg, 11.05.93 #

#++
info -- print short information

info(d)
info(f)

d - domain
f - function

info(d) prints a short information about the domain d. d must have a
method 'info' or an text attribute 'info'. Either the method 'd::info'
is executed or the text 'info' is printed. If the domain has the attibute
'interface', which must be a set of interface names, these names are printed
also.

info(f) prints a short information about the function f. f must have
an string attribute "info". The string is printed unquoted.
++#

info:= fun((
    if args(0) <> 1 then error("wrong no of args") end_if;
    if domattr(domtype(args(1)), "printInfo") = FAIL then
    	print(Unquoted, "Sorry, no information available.")
    else
        domattr(domtype(args(1)), "printInfo")(args(1))
    end_if
)):

DOM_DOMAIN::printInfo:= proc(dom)
    local __name__, dom_name, PRETTY_PRINT;
begin
    PRETTY_PRINT:= FALSE;
    
    if dom::exported = FAIL then dom::exported:= {} end_if;

    dom_name:= dom::name;
    if dom_name = FAIL then dom_name:="<<unknown>>" end_if;

    if dom::info = FAIL then
    	return(print(Unquoted, "Sorry, no information available."));
    end_if;

    if domtype(dom::info) = DOM_STRING then
	print(Unquoted, dom::info)
    else
	dom::info();
    end_if;

    if dom::interface = FAIL then
	return(null())
    end_if;

    if not testtype(dom::interface, Type::SetOf(DOM_IDENT)) then
	error("in attribute \"interface\"")
    end_if;

    if nops(dom::interface) <> 0 then
	print(Unquoted, "Interface:");
	for __name__ in dom::interface do
	    if contains(dom::exported, __name__) then
		print(__name__)
	    else
		print(Unquoted, dom_name."::".__name__)
	    end_if
	end_for
    else
	print(Unquoted, "No Interface.");
    end_if;

    null()
end_proc:

DOM_FUNC_ENV::printInfo:= proc(f) local i, PRETTY_PRINT; begin
    PRETTY_PRINT:= FALSE;
    i:= funcattr(f, "info");
    if i = FAIL then i:= "Sorry, no information available." end_if;
    print(Unquoted, i(f));
end_proc:

# end of file #
