#++ kamo, 06.2.94
  Nonrecursive version of the inverse discrete Fast Fourier Transformation.
  Parameters:
        A - list containing n elements
        m - integer with n = 2^m
  The elements of the transformation are computed in-place.
  Complex arithmetic is assumed and w = exp(2*PI*i/j) is
  expressed in terms of sines and cosines.
++#

ifft := proc(A,m)
local n,l,le,le1,u,w,j,i,ip,t,s,nv2,nm1,k;
begin
    n := 2^m; le1 := n;
    for l from 1 to m do
        le := le1; le1 := 1/2*le; u := 1.0;
        w := float(cos(PI/le1)) + I*float(sin(PI/le1));
        for j from 1 to le1 do
            for i from j to n step le do
                ip := i+le1;
                t := A[i]+A[ip]; s := A[i]-A[ip]; 
                A[ip] := s*u; A[i] := t;
            end_for;
            u := u * w;
        end_for;
    end_for;
    nv2 := 1/2*n; nm1 := n-1; j := 1;
    for i from 1 to nm1 do
        if i < j then
            t := A[j]; A[j] := A[i]; A[i] := t;
        end_if;
        k := nv2;
        while k < j do  j := j-k; k := 1/2*k end_while;
        j := j+k
    end_for;
    for i from 1 to n do  A[i] := A[i]/n end_for;
     A;
end_proc:


