# $Date: 1994/09/07 15:16:22 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 27/01/94 #

#++
has -- test if expression contains certain subexpression

has(e, x)

e - expression
x - expression or list or set of expressions

When in e the expression x is substituted by a different value
and e remains the same then e doesn't contain x.

Special care is taken for FUNC_ENV's x such that also the 0th
operands of the subexpressions of e are searched for.
++#

has:= proc(e, x)
    local __x__, hasf, i, t;
begin
    if args(0) <> 2 then error("wrong no of args") end_if;

    if e::has <> FAIL then return(e::has(e, x)) end_if;

    # test each element of a list or set #
    t:= domtype(x);
    if contains({DOM_LIST,DOM_SET}, t) then
        for i in x do
            if has(e, i) then return(TRUE) end_if;
        end_for;
        return(FALSE)
    end_if;

    # take special care of FUNC_ENV's #
    if t = DOM_FUNC_ENV then

	# hasf -- test if e has a subexpression where FUNC_ENV x is op 0 #
	hasf:= proc(e, x)
	    local i, t;
	begin
	    t:= domtype(e);
	    if t = DOM_EXPR then
		op(e,0);
		if eval(%) = x then return(TRUE) end_if;
		for i in e do
		    if hasf(i, x) then return(TRUE) end_if
		end_for
	    elif contains({ DOM_ARRAY, DOM_LIST, DOM_POLY, DOM_SET,
		DOM_TABLE }, t) then

		if t = DOM_TABLE then
		    for i in e do
			if hasf(op(i,2), x) then return(TRUE) end_if
		    end_for;
		else
		    for i in e do
			if hasf(i, x) then return(TRUE) end_if
		    end_for;
		end_if;
	    end_if;
	    FALSE
	end_proc;

	if hasf(e, x) then return(TRUE) end_if;
    end_if;

    # create unique ident #
    if contains(indets([e,x]), __x__) then 
	__x__:= genident("_has_");
    end_if;

    # contains e subexpression x ? #
    return(bool(e <> subs(e, x=__x__, Unsimplified)))
end_proc:

# end of file #
