# $Date: 1995/01/23 09:55:10 $  $Author: kg $  $Revision: 1.5 $ #
# kg, 08/07/93 #

#++
func -- create a function from an expression

func(e, [x1,...,xn])

e         - expression, a function of x1,...,xn
x1,...,xn - (optional) indeterminates

func views the expression e as a function of the indeterminates x1,...,xn
and returns either a functional expression or a 'pure function' computing
that function. If no indeterminates are given, any indeterminates of e
found by indets are used.

(A pure function is a special form of procedure which evaluates in the
context of the caller and is faster than procedures.)

The arguments are not evaluated!

Examples:

func(sin(x), x)		-> sin
func(x+y, y, x)		-> _plus
func(x+1)		-> id + 1
func(f(a,b), a, b)	-> f
func(f(a,b), a)		-> func(f(a, b), a)
++#

func:= proc(e)
    local X, opX, i, f, mkfunc;
    option hold;
begin
    if testargs() then
	if args(0) < 1 then error("wrong no of args") end_if;
	if args(0) > 1 then
	    X:= { args(i) $ i=2..args(0) };
	    if (nops(X) <> args(0) - 1) or (X <> indets(X)) then
		error("wrong indeterminates")
	    end_if
	end_if
    end_if;

    # get indeterminates #
    if args(0) = 1 then
	X:= [ op(indets(e)) ]
    else
	X:= [ args(i) $ i=2..args(0) ]
    end_if;

    # change expression to functional expression #
    mkfunc:= proc(e)
	local t, i;
    begin
	t:= domtype(e);
	case t
	of DOM_EXPR do
	    if op(e) = opX then return(op(e, 0)) end_if;
	    if { op(e) } = { opX } then
		if e = op(e, 0)(opX) then return(op(e, 0)) end_if
	    end_if;
	    case type(e)
	    of "_plus" do
	    of "_mult" do
		t:= [];
		for i in e do
		    i:= mkfunc(i);
		    if i = null() then return(null()) end_if;
		    t:= append(t, i);
		end_for;
		return((if nops(t) = 1 then
			    op(t)
		        else
			    op(e, 0)(op(t))
			end_if));
	    of "_power" do
		t:= mkfunc(op(e,1));
		if t = null() then return(t) end_if;
		if nops(indets(op(e,2)) intersect { opX }) <> 0 then
		    return(null())
		end_if;
		return(_power(t,op(e,2)));
	    end_case;
	    if nops(e) = 1 then
		t:= mkfunc(op(e,1));
		return((if t = null() then
			    null()
			else
			    op(e, 0) @ t
			end_if));
	    end_if;
	    return(null());
	of DOM_IDENT do
	    return((if e = op(X) then
			id
		    else
			null()
		    end_if));
	end_case;
	if contains({ DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX, DOM_STRING,
		      DOM_BOOL, DOM_NIL, DOM_NULL }, t) then
	    e
	else
	    null()
	end_if
    end_proc;

    # use function directly (if possible) #
    opX:= op(X);
    f:= mkfunc(e);
    if f <> null() then return(context(f)) end_if;

    # generate 'pure' function #
    if nops(X) = 0 then
	newpurefunc(expr2text(hold(func)(e,opX)), NIL, e);
    else
	newpurefunc(expr2text(hold(func)(e,opX)), NIL,
	    misc::subsFreeVars(e, (X[i]=newfuncarg(i)) $ i=1..nops(X), 
	    		       Unsimplified));
    end_if;
end_proc:

# end of file #
