# #
# $Date: 1995/03/29 10:25:34 $ $Author: frankp $ $Revision: 1.7 $ #
# #
# frankp, 27.07.1994 #

#++
conj.mu

	conjugate -- A function for computing the complex 
	             conjugate of an expression


	For computing the complex conjugate of an expression x,
	the method "conjugate" of the domain of x will be used.
	If such a method does not exist, then 'conjugate(x)' 
	will be returned.

	The basis types DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX
	and DOM_EXPR be an exception. These types are treated by
	the procedure 'conjugate'.
	For expressions of type DOM_EXPR the procedure 'conjugate'
	looks for a function attribut 'conjugate', which will
	be used for x if such exists. Otherwise either, if the
	function environment of x is one of the built-in environ-
	ments "_plus", "_mult" or "_power", x will be treated by
	the procedure 'conjugate' or the expression 'conjugate(x)'
	will be returned.

	For the following functions, a function attribut 'conjugate'
	is defined:

	    exp, sin, sinh, cos, cosh, tan, tanh, cot, coth,
            csc, csch, gamma, igamma, erf, sec, sech.
++#

conjugate := func_env(
proc(x)
    name conjugate;
    local t;
begin
    if args(0) <> 1 then error("wrong no of args") end_if;

    if x::conjugate <> FAIL then return( x::conjugate(x) ) end_if;

    t := domtype(x);
    case t
    of DOM_INT     do 
    of DOM_RAT     do
    of DOM_FLOAT   do return( x );
    of DOM_COMPLEX do return( op(x,1) - op(x,2)*I );
    of DOM_EXPR    do
	t := op(x,0);
	if funcattr(level(t,2),"conjugate") <> FAIL then
	    return( funcattr(level(t,2),"conjugate")(op(x)) )
	end_if;

	if t = hold(_plus) or t = hold(_mult) then
	    return( level(t,2)(conjugate(op(x,i)) $ hold(i)=1..nops(x)) )
	end_if;
	if t = hold(_power) and testtype( op(x,2),Type::RealNum ) then
	    return( conjugate(op(x,1))^op(x,2) )
	end_if
    end_case;

    hold(conjugate)(x)
end_proc,
NIL,
table( "type"="conjugate", "print"="conjugate", "conjugate"=op,
       "info"="conjugate(x) -- the complex conjugate of x" )
):

# end of file #
