# #
# $Date: 1995/07/19 08:16:40 $ $Author: kg $ $Revision: 1.14.2.1 $ #
# #
# frankp, 13.12.1994 #

#++
sign.mu

	sign -- sign function for real and complex expressions

	sign(x)

	The sign function returns the sign of a real or complex
	number, defined by x/abs(x) for x<>0.

	'sign(0)' is undefined in the way that 'sign(0)' can be evaluated
	to anything. One can define the value of 'sign(0)' by setting
	    'sign(0)' := a 

	'sign(0)' := 0 is predefined.
	
	For user defined functions, 'sign' tests for the
	function attribute "sign" and call the procedure
	if it exists.
++#

sign := func_env(
proc(x)
    name sign;
    local t, s, ss, f;
begin
    if x::sign <> FAIL then return( x::sign(args()) ) end_if;

    if args(0) <> 1 then 
	error("wrong no of args")
    end_if;

    t := domtype(x);
    case t
    of DOM_INT     do 
    of DOM_RAT     do
    of DOM_FLOAT   do return(stdlib::sign(x));
    of DOM_COMPLEX do return( x/abs(x) );
    of DOM_EXPR    do
	t := op(x,0);
	if domtype(level(t,2)) = DOM_FUNC_ENV then
	    if funcattr(level(t,2),"sign") <> FAIL then
		return( funcattr(level(t,2),"sign")(x) )
	    end_if
	end_if;

	if t = hold(_mult) then
	    s := 1; ss := 1;
	    for f in x do 
		t := sign(f);
		if has(t,hold(sign)) then ss := ss*f else s := s*t end_if
	    end_for;
	    if ss = x then
		return( procname(x) )
	    else
	        return( s*sign(ss) )
	    end_if
	elif t = hold(_plus) then
	    s := {};
	    for f in x do
		t := sign(f);
		if not iszero(t) then 
		    s := (s union {t});	
		    if nops(s) > 1 then break end_if
		end_if
	    end_for;
	    if nops(s) = 1 then return( op(s,1) ) end_if
	elif t = hold(_power) then
	    if testtype(op(x,2),Type::Constant) then
		return( sign(op(x,1))^op(x,2) )
	    end_if
	end_if;

	s := Re(x);
	if not has(s,{Re,Im}) and s <> x then
	    ss := Im(x);
	    if not has(s,{Re,Im}) then
		t := sqrt( s^2*sign(s)^2+ss^2*sign(ss)^2 );
		if not iszero(t) then return( (s+I*ss)/t ) end_if
	    end_if
	end_if
     otherwise
        if testtype( x,Type::Constant ) then
	    s := float(x);
	    if domtype(s) = DOM_FLOAT then
		if iszero(s) then return( sign(0) )
		elif s > 0 then return( 1 ) else return( -1 )
		end_if
	    end_if
	end_if
    end_case;

    procname(x)
end_proc,
NIL,
table( "type"="sign", "print"="sign", "info"="sign(x) -- the sign of x [try ?sign for details]" )
):

sign:=funcattr(sign, "sign", id):

sign:=funcattr(sign,"series",proc() name Series::sign; begin error("no series expansion at the origin") end_proc):

# end of file #
