sech := proc(x)
    # sech(x) = 1/cosh(x) #
begin
    if x::sech <> FAIL then return(x::sech(args())) end_if;

    if args(0) <> 1 then
       error("1 argument expected")
    end_if;

    cosh(x);
    if % = 0 or % = 0.0 then
       error("singularity")
    else
       1/%
    end_if;
end_proc:

sech := funcattr(sech, "type", "sech"):
sech := funcattr(sech, "print", "sech"):
sech := funcattr(sech, "info", "sech -- the hyperbolic secant"):

sech := funcattr(sech, "expand", fun(expand(1/cosh(args(1)))) ):
sech:= funcattr(sech, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(sech)(%)
    else sech(%)
    end_if
)) ):

# end of file #
