# ok, 29/10/94 #

#++
The Digamma and Polygamma functions

psi(x)
psi(x, n)

x - an expression
n - an non negative integer
++#

psi:=proc(x, n)
  name psi;
begin
  if x::psi <> FAIL then return(x::psi(args())) end_if;

  if testtype(x, NUMERIC) then
          Re(float(x));
          if % <= 0.0 and Im(x) = 0 and frac(%) = 0.0 then
             error("singularity encountered");
          end_if
       end_if;

  case args(0) 

    of 1 do

       case type(x) 

         of DOM_INT do
            if x < 100 and 1 < x then # See apendix #
               return( 1/(x-1)+psi(x-1) );
            end_if;
            break;

         of DOM_FLOAT do 
            return( stdlib::psi(x) ); 

         of DOM_COMPLEX do
            if type(op(x,1)) = DOM_FLOAT or type(op(x,2)) = DOM_FLOAT then
               return( stdlib::psi(x) ); 
            end_if;
            break;
       end_case;
 
       break;

    of 2 do 

       if testtype(n, NUMERIC) then
          if type(n) <> DOM_INT or n < 0 then
             error("second argument must be a non negative integer");
          elif n = 0 then 
             return( psi(x) );
          end_if;
             
          case type(x) 

            of DOM_INT do
            of DOM_RAT do
               if x = 1 then
                  return( (-1)^(n+1)*fact(n)*zeta(n+1) );
               elif x = 1/2 then
                  return( (-1)^(n+1)*fact(n)*(2^(n+1)-1)*zeta(n+1) );
	       elif type(2*x) = DOM_INT and abs(x) < 100-n then # See apendix #
                  if x < 0 then
                     return( psi(x+1, n)-(-1)^n*fact(n)/x^(n+1) );
                  else
                     return( (-1)^n*fact(n)/(x-1)^(n+1)+psi(x-1, n) );
                  end_if
                end_if;
                break;

            of DOM_FLOAT do
               return( stdlib::floatpsi(x, n) );

            of DOM_COMPLEX do
               if type(op(x,1)) = DOM_FLOAT or type(op(x,2)) = DOM_FLOAT then
                  return( stdlib::floatpsi(x, n) );
               end_if;
               break;
               
          end_case;
       end_if;

       break;

     otherwise

       error("wrong no of args");

  end_case;

  procname(args())

end_proc:

psi := funcattr(psi, "type", "psi"):
psi := funcattr(psi, "print", "psi"):
psi := funcattr(psi, "diff", proc(e)
    local i, n;
begin
    if nops(e)>=2 then n:=op(e,2) else n:=0 end_if; e:= op(e,1);
    diff(e, args(i) $ i=2..args(0)) * psi(e, n+1)
end_proc):

# Appendix:                                        #
# Due to the complexity to compute psi(x), where x #
# is an integer, compute psi(x) only if x < 100    #
# Also restrict the computation of psi(x,n), where #
# 2*x is an integer. Compute psi(x,n) only if      #
# abs(x) < 100-n. This restrict the number of      #
# recursive calls of psi and the fractional part   #
# of the result.                                   #

psi(1) := -EULER:

#
psi := funcattr(psi, "float", proc(x, n) begin
    case args(0) 
      of 1 do return( psi(float(x)) );
      of 2 do return( psi(float(x), n) );
    end_case;
    error("wrong no of arguments");
end_proc):
#

# main reference : Abramowitz & Stegun, page 258-260         #
# this implementation in exponential with respect to DIGITS, #
# thus works well only for DIGITS about 10                   #
# Implemented by Paul Zimmermann, Inria.                     #

stdlib::floatpsi := proc(z,n)
    local floatz, s, re, im, x, f, i, olds, K, DIGITS, k, X;
begin

   # Note: z must be numeric and n an non negative integer.  #
   #       if Im(z) = 0 and Re(z) <= 0 then frac(Re(z)) must #
   #       unequal zero.                                     #

   floatz:=float(z); re:=Re(floatz); im:=Im(floatz);

   # 
     first use the reflection formula 6.4.7 :
     psi(1-z,n)+(-1)^(n+1)*psi(z,n)=(-1)^n*PI*diff(cot(PI*z),z$n) 
   #
   if re<1/2 then
      return((-1)^n*(float(PI*subs(diff(cot(PI*x),x$n),x=1-floatz))+
             stdlib::floatpsi(1-z,n)))
   end_if;   
   # 
     now we have Re(z)>=1/2. use the series expansion 6.4.10 :
     psi(z,n) = (-1)^(n+1)*n!*sum((z+k)^(-n-1),k=0..infinity) 
   #
   s:=0;
   K:=round(float(10^(DIGITS/(n+4))-re));
   DIGITS:=DIGITS+round(0.435*ln(1.0*K)); # ln(K)/ln(10) #
   for k from 0 to K do
       olds:=s+1/(floatz+k)^(n+1);
       if s=olds then break end_if;
          s:=olds;
   end_for;
   # 
     the rest is R=sum(1/(z+k)^(n+1),k=K+1..infinity)
     which is near from I=int(1/t^(n+1),t=z+K+1/2..infinity)=1/n/(z+K+1/2)^n
     The difference in R-I=sum(a[x],x=z+K+1..infinity)
     where a[x]=1/x^(n+1)-int(1/(x+t)^(n+1),t=-1/2..1/2)
               =1/x^(n+1)*int(1-1/(1+t/x)^(n+1),t=-1/2..1/2)
               =1/x^(n+1)*[ -(n+1)*(n+2)/24/x^2 + O(1/x^4) ]
     Proof [Maple] : map(int,asympt(1-1/(1+t/x)^(n+1),x,4),t=-1/2..1/2);
     and we have 
     sum(1/x^(n+3),x=X..infinity)=1/(n+2)/X^(n+2)+1/2/X^(n+3)+O(1/X^(n+4))
     Proof [Maple] : readlib(eulermac)(1/x^(n+3),x=X..infinity,2);
     Thus sum(a[x],x=X..infinity)=
              -(n+1)/24/X^(n+2)-(n+1)*(n+2)/48/X^(n+3)+O(1/X^(n+4))
     and R=1/n/(X-1/2)^n-(n+1)/24/X^(n+2)-(n+1)*(n+2)/48/X^(n+3)+O(1/X^(n+4))
     with X=z+K+1
   #
   X:=floatz+k+1;
   s:=s+1/(X-1/2)^n/n-(n+1)/24/X^(n+2)-(n+1)*(n+2)/48/X^(n+3);
   (-1)^(n+1)*fact(n)*s

end_proc:

# psi(x+i,n) = psi(x,n)+(-1)^n*n!*(1/x^(n+1)+1/(x+1)^(n+1)+...+1/(x+i-1)^(n+1)) #
psi := funcattr(psi, "expand", proc(x,n) local i,j,t,rng,N;
begin
   if args(0)=1 then n:=0; N:=null() else N:=n end_if;
   i:=coeff(x,0);
   if type(i)=DOM_INT then
      x:=x-i;
      if i<0 then rng:=i..-1 else rng:=0..i-1 end_if;
      t:=_plus(1/(x+j)^(n+1) $ j=rng);
      hold(psi)(x,N)+sign(i)*(-1)^n*fact(n)*t
   else hold(psi)(x,N)
   end_if
end_proc):

psi:=funcattr(psi,"series",proc(f,n,x,ord) # series(psi(f,n),x,ord) #
name Series::psi;
local l,k,s,f0;
begin
   if args(0)=3 then # usual Psi function, not its derivatives #
      ord:=x; x:=n; n:=0;
   end_if;
   if limit(f,x=0,Right)=infinity then # expansion at infinity #
      if n=0 then # formula 6.3.18 in Abramowitz & Stegun #
         f0:=lmonomial(Series::series(f,x,2));
         # ln(f) = ln(f0+(f-f0)) = ln(f0)+ln(1+(f-f0)/f0) #
         l:=[-1/2/f,-bernoulli(2*k)/2/k*f^(-2*k)$k=1..(ord-1) div 2];
         if nops(l)>ord then l[ord+1]:=NIL end_if;
         s:=Series::series(_plus(ln(1+(f-f0)/f0),op(l)),x,ord);
         s:=gseries::convert(s);
         extsubsop(s,1=[[1,ln(f0)],op(extop(s,1))])
      else # formula 6.4.11 in Abramowitz & Stegun #
         s:=(-1)^(n-1);
         l:=[s*fact(n-1),s*fact(n)/2,
		(s*bernoulli(2*k)*fact(2*k+n-1)/fact(2*k),0)$k=1..(ord-1) div 2];
         if nops(l)>ord then l[ord+1]:=NIL end_if;
         Puiseux::create(1,n,n+ord,l,x)
      end_if
   else
      s:=Series::Puiseux(f,x,ord);
      if ldegree(s)>0 then # expansion in zero #
         # use formula 6.4.6 of Abramowitz & Stegun #
         series(-(-1)^n*fact(n)/f^(n+1)+psi(f+1,n),x,ord)
      else
         Series::unknown(psi(f,n),x,ord)
      end_if
   end_if
end_proc):

psi := funcattr(psi,"info","psi -- the Digamma and Polygamma functions [try ?psi for options]"):

# end of file #

