# $Date: 1995/07/14 10:18:01 $ $Author: kg $ $Revision: 1.11.2.1 $ #

# kg, 13/01/94 #

#++
ln -- the natural logarithm

ln(x)

x - expression
++#

ln:= proc(x)
    name ln;
begin
    if x::ln <> FAIL then return(x::ln(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_FLOAT do
	return(funcattr(ln,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(ln,"float")(x))
	end_if;
	break;

    of "exp" do return(op(x,1));
    end_case;

    if x = 0 then error("singularity") end_if;
    procname(x)
end_proc:

ln:= funcattr(ln, "print", "ln"):

# ln(x ^ n)     = n * ln(x)                              #
# ln(x * y)     = ln(x) + ln(y)                          #
# ln(-c * x)    = ln(c) + ln(-x)                         #
# ln(exp(x))    = x                                      #

ln := funcattr(ln, "expand", proc(x)
  local n, t, y;
begin
  y := normal(expand(x));

  case type(y)

    of "_mult" do

       n := op(y, 1); y := subsop(y, 1=null());
       return(expand(ln(n) + ln(y)));

    of "_power" do

       return(expand(op(y, 2) * ln(op(y, 1))));

    of "exp" do
 
       return(op(y,1));
 
  end_case;
 
  ln(y)
 
end_proc):

ln := funcattr(ln, "simplify", proc(x)
    local t;
begin
    case type(x) 
    of DOM_RAT do return(ln(op(x,1))-ln(op(x,2)))
    of "_power" do return( simplify(op(x,2))*ln(simplify(op(x,1))) )
    of "_mult"  do
	t:=simplify(x);
	if type(t)="_mult" then
	    return( simplify(_plus( op(map([op(t)],ln)) )) )
	elif t <> x then return( funcattr(ln,"simplify")(t) )
	else return( hold(ln)(x) )
	end_if
    of "exp"    do return( simplify(op(x)) )
    end_case;
    t := simplify(x);
    if t <> x then funcattr(ln,"simplify")(t) else hold(ln)(x) end_if
end_proc):

ln := funcattr( ln, "sign", fun(
    (if sign(op(args(1),1)) = 1 then
	sign( op(args(1),1)-1 )
    else
	hold(sign)(args(1))
    end_if))
):

ln := funcattr( ln,"info","ln -- the natural logarithm"):

ln(1):= 0:
ln(E):= 1:
ln(1/E):= -1:

# end of file #
