# $Date: 1995/07/14 10:17:56 $ $Author: kg $ $Revision: 1.16.2.1 $ #

# kg, 13/01/94 #

#++
cos -- the cosine

cos(x)

x - expression
++#

cos:= proc(x)
    local f;
    name cos;
begin
    if x::cos <> FAIL then return(x::cos(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(cos(-x)) end_if;
	break;

    of DOM_FLOAT do
	return(funcattr(cos,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	       return(funcattr(cos,"float")(x))
	   end_if;
	if op(x,1) = 0 then return(cosh(-x*I)) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(cos(-x)) end_if;
	    if domtype(f) = DOM_FLOAT then break end_if;
	else
	    break
	end_if;

	if nops(x) = 2 then
	    if op(x,1) = PI then
		if f < 1/2 then break end_if;
		if f < 1 then return(-cos((1-f)*PI)) end_if;
		if f < 2 then return(cos((2-f)*PI)) end_if;
		return(cos((f-2*(floor(f) div 2))*PI));
	    end_if
	end_if;
	break;

    of "asin" do return(sqrt(1-op(x)^2));
    of "acos" do return(op(x));
    of "atan" do return(1/sqrt(1+op(x)^2));
    end_case;

    procname(x)
end_proc:

cos:= funcattr(cos, "print", "cos"):

cos(0):= 1:
cos(PI/12):= (6^(1/2)+2^(1/2))/4: # simpler than ((2+3^(1/2))^(1/2))/2: #
cos(PI/8):= ((2+2^(1/2))^(1/2))/2:
cos(PI/6):= (3^(1/2))/2:
cos(PI/4):= (2^(1/2))/2:
cos(PI/3):= 1/2:
cos(3*PI/8):= ((2-2^(1/2))^(1/2))/2:
cos(5*PI/12):= ((2-3^(1/2))^(1/2))/2:
cos(PI/2):= 0:
cos(PI):= -1:
cos(I):= cosh(1):

# cos(-x)     = cos(x)                                       #
# cos(x +- y) = cos(x) * cos(y) -+ sin(x) * sin(y)           #   
#              n/2                                           #
#              ---                                           #
#              \   (  n )                                    #
# cos(n * x) = /   ( 2*i) cos(x)^(n-2*i)*sin(x)^(2*i)*(-1)^i #
#              ---                                           #
#              i=0                                           #



cos := funcattr(cos, "expand", proc(x)
  local n, t, y;
begin
  y := expand(x);

  case type(y)

    of "_plus" do

       n := op(y, 1); y := subsop(y, 1=null());
       return(expand(cos(n)*cos(y)-sin(n)*sin(y)));

    of "_mult" do

       n := op(y, nops(y)); t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(cos(-y)));
          elif t = DOM_INT and n > 0 then
             y := y / n;
             return(expand(2*cos((n-1)*y)*cos(y)-cos((n-2)*y)));
          end_if
       end_if
 
  end_case;
 
  cos(y)
 
end_proc):

cos:= funcattr( cos, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(cos)(%)
    else cos(%)
    end_if
)) ):

cos:= funcattr( cos, "info", "cos -- the cosine" ):
# end of file #
