# $Date: 1995/06/08 11:17:44 $ $Author: frankp $ $Revision: 1.6 $ #

# kg, 13/01/94 #

#++
atanh -- the inverse hyperbolic tangens

atanh(x)

x - expression
++#

atanh:= proc(x)
    local f;
    name atanh;
begin
    if x::atanh <> FAIL then return(x::atanh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
        if x = 1 then
           error("singularity encountered");
	elif x < 0 then return(-atanh(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(atanh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(atanh,"float")(x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-atanh(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

atanh:= funcattr(atanh, "print", "atanh"):

atanh:= funcattr(atanh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / (1-e^2)
end_proc):

atanh(0):= 0:

# end of file #
