# $Date: 1995/06/08 11:17:43 $ $Author: frankp $ $Revision: 1.9 $ #

# kg, 13/01/94 #

#++
atan -- the inverse tangens

atan(x)
atan(u,v)

x   - expression
u,v - real quantifiers, representing the complex number u+I*v

atan(x) computes the inverse tangens of an expression x.

atan(u,v) computes the principal value of the argument of the complex
number u+I*v, so -PI < atan(u,v) <= PI.  u and v represents real quantifiers.
++#

atan:= proc(x)
    local f, y, sx, sy;
    name atan;
begin
    if x::atan <> FAIL then return(x::atan(args())) end_if;
    if args(0) < 1 or args(0) > 2 then error("wrong no of args") end_if;
    if args(0) = 2 then
    # the two-argument atan #
	y := args(2);
	if y::atan <> FAIL then return(y::atan(args())) end_if;
	sx := sign(x); 
	sy := sign(y);
	if domtype(sx) = DOM_COMPLEX or domtype(sy) = DOM_COMPLEX then
	    error("expecting real quantifiers")
	elif domtype(x) = DOM_FLOAT and testtype(sy,NUMERIC) and
	  domtype(y) <> stdlib::Infinity or domtype(y) = DOM_FLOAT and 
	  testtype(sx,NUMERIC) and domtype(x) <> stdlib::Infinity then
	    if sx = 0 then return( float(1/2*sy*PI) )
	    else return( funcattr(atan,"float")(y/x) )
	    end_if
	elif y = 0 then return( 1/2*(1-sx)*PI )
	elif testtype(sx,NUMERIC) then
	    if sx = 0 then return( 1/2*sy*PI )
	    elif domtype(x) = stdlib::Infinity then
		if testtype(sy,NUMERIC) and domtype(y) <> stdlib::Infinity then
		    return( 1/2*sy*(1-sx)*PI )
		else
		    return( procname(x,y) )
		end_if
	    elif domtype(y) = stdlib::Infinity then
		if testtype(sy,NUMERIC) then return( 1/2*sy*PI )
		else return( procname(x,y) )
		end_if
	    elif sx = 1 then
		return( atan(y/x) )
	    else
		return( atan(y/x)+PI*sy )
	    end_if
	else
	    return( procname(x,y) )
	end_if
    end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-atan(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(atan,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(atan,"float")(x))
	end_if;
	if x = I then error("singularity") end_if;
	if op(x,1) = 0 then return(I*atanh(-I*x)) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-atan(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

atan:= funcattr(atan, "print", "atan"):

atan:= funcattr(atan, "info", "atan -- the inverse tangens (including the two-argument function atan) [try ?atan for help]"):

atan:= funcattr(atan, "diff", proc(e)
    local i;
begin
    if nops(e) = 1 then e:= op(e,1) else e:= op(e,2)/op(e,1) end_if;
    diff(e, args(i) $ i=2..args(0)) / (1+e^2)
end_proc):

atan(0):= 0:
atan((3^(1/2))/3):= PI/6:
atan(1):= PI/4:
atan(3^(1/2)):= PI/3:
atan(infinity):= 1/2*PI:
atan(-infinity):= -1/2*PI:
atan(I*infinity):= 1/2*PI:
atan(-I*infinity):= -1/2*PI:

# end of file #
