# $Date: 1995/06/08 11:17:42 $ $Author: frankp $ $Revision: 1.8 $ #

# kg, 13/01/94 #

#++
asin -- the inverse sine

asin(x)

x - expression
++#

asin:= proc(x)
    local f;
    name asin;
begin
    if x::asin <> FAIL then return(x::asin(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-asin(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(asin,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(asin,"float")(x))
	end_if;
	if op(x,1) = 0 then return(asinh(-x*I)*I) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-asin(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

asin:= funcattr(asin, "print", "asin"):

asin:= funcattr(asin, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / sqrt(1-e^2)
end_proc):

asin:= funcattr(asin, "info", "asin -- the inverse sine" ):

asin(0):= 0:
asin(1/2):= PI/6:
asin((2^(1/2))/2):= PI/4:
asin((3^(1/2))/2):= PI/3:
asin(1):= PI/2:
asin(infinity):= -I*infinity:
asin(-infinity):= I*infinity:
asin(I*infinity):= I*infinity:
asin(-I*infinity):= -I*infinity:

# end of file #
