
# ok, 27/01/94 #

#++
acoth -- the inverse hyperbolic cotangens

acoth(x)

x - expression
++#

acoth:= proc(x)
    name acoth;
begin
    if x::acoth <> FAIL then return(x::acoth(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x = 1 then
           error("singularity")
	elif x < 0 then
           return(-acoth(-x))
        end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(acoth,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(acoth,"float")(x))
	elif op(x,1) = 0 then
            return(-I*acot(-I*x))
	elif op(x,1) < 0 and op(x,2) < 0 then
            return(-acoth(-x))
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

acoth:= funcattr(acoth, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) * ( -1/(e^2-1) )
end_proc):

acoth:= funcattr(acoth, "type", "acoth"):
acoth:= funcattr(acoth, "print", "acoth"):

acoth:= funcattr(acoth, "float", proc(e)
    name acoth;
begin
    # acoth(0) = PI/2*I              #
    # acoth(1) = singularity         #
    # acoth(e) = atanh(1/e) , e <> 0 #
    if e = 1 or e = 1.0 then
       error("singularity");
    elif e = 0.0 then
       float(PI/2)
    else
       funcattr(atanh, "float")(1/e)
    end_if
end_proc):

acoth(0)   := PI/2*I:

acoth:= funcattr(acoth,"info","acoth -- the inverse hyperbolic cotangent"):

# end of file #
