# $Date: 1995/06/08 11:17:36 $ $Author: frankp $ $Revision: 1.4 $ #

# kg, 13/01/94 #

#++
acosh -- the inverse hyperbolic cosine

acosh(x)

x - expression
++#

acosh:= proc(x)
    name acosh;
begin
    if x::acosh <> FAIL then return(x::acosh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 1 then error("invalid argument") end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(acosh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(acosh,"float")(x))
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

acosh:= funcattr(acosh, "print", "acosh"):

acosh:= funcattr(acosh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / sqrt(e^2-1)
end_proc):

acosh(1):= 0:

acosh:= funcattr(cosh, "info", "acosh -- the inverse hyperbolic cosine"):

# end of file #
