# $Date: 1995/06/08 11:17:35 $ $Author: frankp $ $Revision: 1.9 $ #

# kg, 13/01/94 #

#++
acos -- the inverse cosine

acos(x)

x - expression
++#

acos:= proc(x)
    local f;
    name acos;
begin
    if x::acos <> FAIL then return(x::acos(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(PI - acos(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(acos,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(acos,"float")(x))
	end_if;
	if op(x,1) = 0 then return(PI/2 - asin(x)) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(PI - acos(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

acos:= funcattr(acos, "print", "acos"):

acos:= funcattr(acos, "diff", proc(e)
    local i;
begin
    e:= op(e,1); -diff(e, args(i) $ i=2..args(0)) / sqrt(1-e^2)
end_proc):

acos:= funcattr(acos, "info", "acos -- the inverse cosine" ):

acos:=funcattr(acos,"series",
# formula 4.4.2 of Abr. & Stegun #
proc(f,x,n) begin Series::Puiseux(PI/2-asin(f),x,n) end_proc):

acos(1):= 0:
acos((3^(1/2))/2):= PI/6:
acos((2^(1/2))/2):= PI/4:
acos(1/2):= PI/3:
acos(0):= PI/2:
acos(-1):= PI:
acos(infinity):= I*infinity:
acos(-infinity):= PI-I*infinity:
acos(I*infinity):= 1/2*PI-I*infinity:
acos(-I*infinity):= 1/2*PI + I*infinity:


# end of file #
