# $Date: 1995/06/20 16:46:04 $ $Author: cube $ $Revision: 1.5.2.1 $ #

# frankp, 01/02/95 #

#++
	abs -- returns the absolute value of an expression

	abs(x)

	x - expression
++#

abs := func_env(
proc(x)
    name abs;
    local t, aa, a, f;
begin
    if x::abs <> FAIL then return( x::abs(args()) ) end_if;

    if args(0) <> 1 then
	error("wrong no of args")
    end_if;

    case domtype(x)
    of DOM_INT     do
    of DOM_RAT     do
    of DOM_FLOAT   do
    of DOM_COMPLEX do return( stdlib::abs(x) )
    of DOM_EXPR    do
	t := op(x,0);
        if domtype(level(t,2)) = DOM_FUNC_ENV then
            if funcattr(level(t,2),"abs") <> FAIL then
                return( funcattr(level(t,2),"abs")(op(x)) )
            end_if
        end_if;

        if t = hold(_mult) then
	    aa := 1; a := 1;
            for f in x do
		t := abs(f);
		if has(t,hold(abs)) then aa := aa*f else a := a*t end_if
	    end_for;
	    if aa <> x then
		if aa <> 1 then return( a*hold(abs)(aa) )
		else return( a )
		end_if
	    end_if
	elif t = hold(_plus) then
            a := Re(x);
            if not has(a,{hold(Re),hold(Im)}) then
                aa := Im(x);
                if not has(aa,{hold(Re),hold(Im)}) then
                   return( expand(sqrt(a^2+aa^2)) )
                end_if
	    end_if
	elif t = hold(_power) then
	    if testtype( op(x,2),NUMERIC ) then
	        return( abs(op(x,1))^op(x,2) )
	   end_if
	elif t = hold(abs) then
           return(x)
	end_if
    end_case;

    procname(x)
end_proc,
NIL,
table( "type"="abs", "print"="abs",
       "info"="abs(x) -- absolute value of x" )
):

abs(I):= 1: abs(PI):=PI: abs(E):=E: abs(EULER):=EULER:

abs:= funcattr(abs, "diff",
    fun(sign(op(args(1),1)) *
        diff(op(args(1),1), args(i) $ hold(i)=2..args(0)))):

abs := funcattr( abs, "sign", fun( (if iszero(sign(0)) then 1 else args(1) end_if) ) ):

# end of file #
