#++

plotsetup(dev)

dev -- device ( x11 or term )

plotsetup is used for plotting with mupad (terminal version of MuPAD).
If mupad is running in an X11 environment, plotsetup(x11) modify the
functions plot2d and plot3d to display the graphic in a separate
window on the workstation display. 
plotdevice(term) resets plot2d and plot3d.
plotdevice is only available on Unix based operating systems.
 
++#

sharelib::plot2d_ext := proc()
  name plot2d;
begin
    sharelib::show_plot(traperror(sharelib::plot2d_sys(args())))
end_proc:

sharelib::plot3d_ext := proc()
  name plot3d;
begin
    sharelib::show_plot(traperror(sharelib::plot3d_sys(args())))
end_proc:

sharelib::show_plot := proc(errnr)
begin
    if errnr <> 0 then
       if sharelib::DEVICE = x11 then
          if system("vcam save.mp") <> 0 then
             print("Can't spawn external previewer.")
          else
             return( null() )
          end_if;
          print("Plotdata saved in binary file save.mp")
       end_if
    end_if;
    null()
end_proc:

sharelib::plotsetup := proc(dev)
begin
  if sysname() <> "UNIX" then
     error("Not an Unix OS.");
  end_if;

  case dev

   of term do

     sharelib::DEVICE := term;
     if sharelib::plot2d_sys <> FAIL then
        plot2d := sharelib::plot2d_sys;
        plot3d := sharelib::plot3d_sys;
     end_if;
     break;

  of x11 do

    sharelib::DEVICE := x11;
    if sharelib::plot2d_sys = FAIL then
       sharelib::plot2d_sys := plot2d;
       sharelib::plot3d_sys := plot3d;
    end_if;
    plot2d := sharelib::plot2d_ext;
    plot3d := sharelib::plot3d_ext;
    break;
 
  otherwise

    error("Unknown device '".dev."'.");
 
  end_case;
  
  null()
  
end_proc:
