#++

sharelib::edit(filename)

filename -- identifier or string

edit invokes an editor in the host operating system and search for
the file 'filename' in the directories specified by READ_PATH and 
LIB_PATH. If edit can't find this file, the suffix '.mu' is appended 
to the filename, and edit searches again. You can set 
sharelib::APPEND_SUFFIX := FALSE: , if you don't want this. After leaving 
the editor the given file is reloaded. You can set
sharelib::RELOAD := FALSE: , if you don't want this. By default, edit
uses the editor "vi". Set sharelib::EDITOR to your favorite editor, for
example "textedit" or "emacs".
Note: metacharacters are not recognized in the filename, for example 
      sharelib::edit("~/test*1?"):

++#

if not testtype(sharelib::APPEND_SUFFIX, DOM_BOOL) then
   sharelib::APPEND_SUFFIX := TRUE
end_if:
if not testtype(sharelib::RELOAD, DOM_BOOL) then
   sharelib::RELOAD := TRUE
end_if:
if not testtype(sharelib::EDITOR, DOM_STRING) then
  sharelib::EDITOR := "vi"
end_if:

sharelib::edit := proc(file)
  option hold;
  local f, fd, fullname, pass, path, path_list, tmp, READ_PATH, LIB_PATH;
begin
  if sysname() <> "UNIX" then
     error("Not an Unix OS");
  end_if;

  fullname := ""; path_list := null(); f := file;
  if testtype(READ_PATH, Type::SequenceOf(DOM_STRING)) then
     path_list := READ_PATH; 
     READ_PATH := NIL; 
  end_if;
  path_list := path_list , "." ;
  if testtype(LIB_PATH, Type::SequenceOf(DOM_STRING)) then
     path_list := path_list , LIB_PATH; 
     LIB_PATH := NIL;
  end_if;
  for pass from 1 to 2 do
      for path in path_list do
          tmp := path."/".file;
	  fd:=fopen(tmp);
          if fd <> FAIL then
             fullname := tmp; fclose(fd); break;
          end_if
      end_for;
      if fullname <> "" then break end_if;
      fd:=fopen(file);
      if fd <> FAIL then
         fullname := file; break
      elif not sharelib::APPEND_SUFFIX or strmatch("".file, "\*.mu") then
         break 
      end_if;
      file := "".file.".mu";
  end_for;
  if fullname <> "" then 
     system(sharelib::EDITOR." ".fullname);
     if sharelib::RELOAD then
        fread(fullname);
     end_if;
  else 
     error("Can't find file '".f."'.")
  end_if;
  null()
end_proc:
