#++

  RGB colors

  These definitions are taken from:
  Ralf Schaper, Grafik mit Mathematica, Addison-Wesley, 1994, pp. 192-194

  For additional colors see also: X11/lib/X11/rgb.txt

  Example: 

  plot2d([Mode=Curve, [sin(u), cos(u)], u=[-PI,PI],         
          Color=[Flat,RGB::VioletDark]
         ]):

++#

RGB := domain():
RGB::name := "RGB":
RGB::info := "RGB values for color names. See also: RGB::interface":

#++

RGB::ColorNames()      -- returns a list of all (predefined) color names
RGB::ColorNames(color) -- returns a list of all (predefined) color names 
                          containing color

Example: RGB::ColorNames(Olive) yields [Olive, OliveGreenDark, OliveDrab]
	
++#

RGB::ColorNames := proc(color)
  option hold;
  local c, eqn, family, l;
begin
  family := (if args(0) = 1 then TRUE else FALSE end_if);
  l := [];
  for eqn in RGB do
      if testtype(op(eqn, 2), Type::ListOf(DOM_FLOAT, 3, 3)) then
         c := op(eqn, 1);
         if not family or (family and strmatch(c, "\*".color."\*")) then
            l := append(l, text2expr(c) )
         end_if
      end_if
  end_for;
  l
end_proc:


RGB::AliceBlue 		:= [0.941206,0.972503,1.0] :
RGB::AlizarinCrimson 	:= [0.889996,0.149998,0.209998] :
RGB::Antique 		:= [0.980575,0.92233,0.844661] :
RGB::Aquamarine 	:= [0.498001,1.0,0.831401] :
RGB::AquamarineMedium 	:= [0.400006,0.803903,0.666707] :
RGB::AureolineYellow 	:= [1.0,0.659993,0.140004] :
RGB::Azure 		:= [0.94174,1.0,1.0] :
RGB::Banana 		:= [0.889996,0.810007,0.340007] :
RGB::Beige 		:= [0.640004,0.580004,0.5] :
RGB::Bisque 		:= [1.0,0.898053,0.771844] :
RGB::Black 		:= [0.0,0.0,0.0] :
RGB::BlanchedAlmond 	:= [1.0,0.921598,0.803903] :
RGB::Blue 		:= [0.0,0.0,1.0] :
RGB::BlueLight 		:= [0.678396,0.847102,0.902005] :
RGB::BlueMedium 	:= [0.0,0.0,0.803903] :
RGB::BlueViolet 	:= [0.5412,0.1686,0.886303] :
RGB::Brick 		:= [0.610004,0.400006,0.119999] :
RGB::Brown 		:= [0.5,0.164693,0.164693] :
RGB::BrownOadder 	:= [0.859996,0.159993,0.159993] :
RGB::BrownOchre 	:= [0.53,0.260002,0.119999] :
RGB::Burlywood 		:= [0.870602,0.721595,0.529405] :
RGB::BurntSienna 	:= [0.539994,0.209998,0.059999] :
RGB::BurntUmber 	:= [0.539994,0.200003,0.140004] :
RGB::Cadet 		:= [0.372494,0.619602,0.627506] :
RGB::CadmiumLemon 	:= [1.0,0.889996,0.009995] :
RGB::CadmiumOrange 	:= [1.0,0.380001,0.009995] :
RGB::CadmiumRedDeep 	:= [0.889996,0.089999,0.050005] :
RGB::CadmiumRedLight 	:= [1.0,0.009995,0.050005] :
RGB::CadmiumYellow 	:= [1.0,0.599994,0.069994] :
RGB::CadmiumYellowLight := [1.0,0.689993,0.059999] :
RGB::Carrot 		:= [0.930006,0.569994,0.129994] :
RGB::Cerulean 		:= [0.020005,0.719993,0.799997] :
RGB::Chartreuse 	:= [0.498001,1.0,0.0] :
RGB::Chocolate 		:= [0.823496,0.411802,0.117603] :
RGB::ChromeOxideGreen 	:= [0.400006,0.5,0.080004] :
RGB::CinnabarGreen 	:= [0.380001,0.700003,0.159993] :
RGB::Cobalt 		:= [0.239998,0.350002,0.670003] :
RGB::CobaltGreen 	:= [0.239998,0.569994,0.250008] :
RGB::CobaltVioletDeep 	:= [0.569994,0.129994,0.619999] :
RGB::ColdGray 		:= [0.5,0.539994,0.53] :
RGB::Coral 		:= [1.0,0.498001,0.3137] :
RGB::CoralLight 	:= [0.941206,0.501999,0.501999] :
RGB::CornflowerBlue 	:= [0.392193,0.584307,0.929395] :
RGB::Cornsilk 		:= [1.0,0.972503,0.862697] :
RGB::Cyan 		:= [0.0,1.0,1.0] :
RGB::CyanWhite 		:= [0.878399,1.0,1.0] :
RGB::DarkOrange 	:= [1.0,0.548997,0.0] :
RGB::DeepPink 		:= [1.0,0.078402,0.576495] :
RGB::DeepOchre 		:= [0.449995,0.239998,0.099994] :
RGB::DimGray 		:= [0.333333,0.333333,0.333333] :
RGB::DodgerBlue 	:= [0.117603,0.564699,1.0] :
RGB::Eggshell 		:= [0.990005,0.900006,0.790002] :
RGB::EmeraldGreen 	:= [0.0,0.790002,0.340007] :
RGB::EnglishRed 	:= [0.829997,0.239998,0.099994] :
RGB::Firebrick 		:= [0.698004,0.133305,0.133305] :
RGB::Flesh 		:= [1.0,0.490005,0.250008] :
RGB::FleshOchre 	:= [1.0,0.340007,0.129994] :
RGB::Floral 		:= [1.0,0.980407,0.941206] :
RGB::ForestGreen 	:= [0.133305,0.545106,0.133305] :
RGB::Gainsboro 		:= [0.862697,0.862697,0.862697] :
RGB::GeraniumLake 	:= [0.889996,0.069994,0.189993] :
RGB::Ghost 		:= [0.972503,0.972503,1.0] :
RGB::Gold 		:= [1.0,0.843104,0.0] :
RGB::GoldOchre 		:= [0.780007,0.47,0.149998] :
RGB::Goldenrod 		:= [0.8549,0.647099,0.125507] :
RGB::GoldenrodDark 	:= [0.721595,0.525498,0.043107] :
RGB::GoldenrodLight 	:= [0.980407,0.980407,0.823496] :
RGB::GoldenrodPale 	:= [0.933302,0.909803,0.666707] :
RGB::Green 		:= [0.0,1.0,0.0] :
RGB::GreenDark 		:= [0.0,0.392193,0.0] :
RGB::GreenPale 		:= [0.596103,0.984298,0.596103] :
RGB::GreenYellow 	:= [0.678396,1.0,0.184301] :
RGB::GreenishUmber 	:= [1.0,0.239998,0.050005] :
RGB::Gray 		:= [0.752907,0.752907,0.752907] :
RGB::Honeydew 		:= [0.941206,1.0,0.941206] :
RGB::HotPink 		:= [1.0,0.411802,0.705893] :
RGB::IndianRed 		:= [0.689993,0.089999,0.119999] :
RGB::Indigo 		:= [0.03,0.179998,0.329997] :
RGB::Ivory 		:= [1.0,1.0,0.941206] :
RGB::IvoryBlack 	:= [0.159993,0.140004,0.129994] :
RGB::Khaki 		:= [0.941206,0.902005,0.548997] :
RGB::KhakiDark 		:= [0.741203,0.717597,0.419599] :
RGB::LampBlack 		:= [0.179998,0.280007,0.230003] :
RGB::Lavender 		:= [0.902005,0.902005,0.980407] :
RGB::LavenderBlush 	:= [1.0,0.941206,0.960799] :
RGB::LawnGreen 		:= [0.486297,0.988205,0.0] :
RGB::LemonChiffon 	:= [1.0,0.980407,0.803903] :
RGB::LightBeige 	:= [0.960799,0.960799,0.862697] :
RGB::LightGoldenrod 	:= [0.933302,0.866695,0.509796] :
RGB::LightGray 		:= [0.666666,0.666666,0.666666] :
RGB::LightSalmon 	:= [1.0,0.627506,0.478393] :
RGB::LimeGreen 		:= [0.196097,0.803903,0.196097] :
RGB::Linen 		:= [0.980407,0.941206,0.902005] :
RGB::MadderLakeDeep 	:= [0.889996,0.179998,0.189993] :
RGB::Magenta 		:= [1.0,0.0,1.0] :
RGB::ManganeseBlue 	:= [0.009995,0.659993,0.619999] :
RGB::Maroon 		:= [0.690207,0.188192,0.376507] :
RGB::MarsOrange 	:= [0.589999,0.269997,0.080004] :
RGB::MarsYellow 	:= [0.889996,0.440001,0.099994] :
RGB::Melon 		:= [0.889996,0.659993,0.410001] :
RGB::MidnightBlue 	:= [0.097995,0.097995,0.439207] :
RGB::Mint 		:= [0.739998,0.990005,0.790002] :
RGB::MintCream 		:= [0.960799,1.0,0.980407] :
RGB::MistyRose 		:= [1.0,0.894101,0.882397] :
RGB::Moccasin 		:= [1.0,0.894101,0.709799] :
RGB::NaplesYellowDeep 	:= [1.0,0.659993,0.069994] :
RGB::Navajo 		:= [1.0,0.870602,0.678396] :
RGB::Navy 		:= [0.0,0.0,0.501999] :
RGB::NavyBlue 		:= [0.0,0.0,0.501999] :
RGB::OldLace 		:= [0.992203,0.960799,0.902005] :
RGB::Olive 		:= [0.230003,0.370006,0.170003] :
RGB::OliveDrab 		:= [0.419599,0.556902,0.137303] :
RGB::OliveGreenDark 	:= [0.333293,0.419599,0.184301] :
RGB::Orange 		:= [1.0,0.5,0.0] :
RGB::OrangeRed 		:= [1.0,0.270608,0.0] :
RGB::Orchid 		:= [0.8549,0.439207,0.839198] :
RGB::OrchidDark 	:= [0.599994,0.196097,0.799997] :
RGB::OrchidMedium 	:= [0.729408,0.333293,0.827494] :
RGB::PapayaWhip 	:= [1.0,0.9373,0.835307] :
RGB::Peach		:= [0.44, 0.26, 0.26] :
RGB::PeachPuff 		:= [1.0,0.8549,0.725501] :
RGB::Peacock 		:= [0.200003,0.629994,0.790002] :
RGB::PermanentGreen 	:= [0.039995,0.790002,0.170003] :
RGB::PermanentRedViolet := [0.859996,0.149998,0.269997] :
RGB::Peru 		:= [0.803903,0.521607,0.247093] :
RGB::Pink 		:= [1.0,0.752907,0.796106] :
RGB::PinkLight 		:= [1.0,0.713706,0.756905] :
RGB::Plum 		:= [0.866695,0.627506,0.866695] :
RGB::PowderBlue 	:= [0.690207,0.878399,0.902005] :
RGB::PrussianBlue	:= [0.18, 0.18, 0.31] :
RGB::Purple 		:= [0.627506,0.125507,0.941206] :
RGB::PurpleMedium 	:= [0.576495,0.439207,0.858806] :
RGB::Raspberry 		:= [0.53,0.149998,0.340007] :
RGB::RawSienna 		:= [0.780007,0.380001,0.080004] :
RGB::RawUmber 		:= [0.449995,0.290002,0.069994] :
RGB::Red 		:= [1.0,0.0,0.0] :
RGB::RoseMadder 	:= [0.889996,0.209998,0.219993] :
RGB::RosyBrown 		:= [0.737297,0.560793,0.560793] :
RGB::RoyalBlue 		:= [0.254906,0.411802,0.882397] :
RGB::SaddleBrown 	:= [0.545106,0.270608,0.074496] :
RGB::Salmon 		:= [0.980407,0.501999,0.447096] :
RGB::SandyBrown 	:= [0.956893,0.643101,0.376507] :
RGB::SapGreen 		:= [0.189993,0.5,0.080004] :
RGB::SeaGreen 		:= [0.180395,0.545106,0.341197] :
RGB::SeaGreenDark 	:= [0.560793,0.737297,0.560793] :
RGB::SeaGreenLight 	:= [0.125507,0.698004,0.666707] :
RGB::SeaGreenMedium 	:= [0.235298,0.702002,0.443098] :
RGB::Seashell 		:= [1.0,0.960799,0.933302] :
RGB::Sepia 		:= [0.370006,0.149998,0.069994] :
RGB::Sienna 		:= [0.627506,0.321604,0.176504] :
RGB::SkyBlue 		:= [0.529405,0.807794,0.921598] :
RGB::SkyBlueDeep 	:= [0.0,0.749,1.0] :
RGB::SkyBlueLight 	:= [0.529405,0.807794,0.980407] :
RGB::SlateBlue 		:= [0.415693,0.352901,0.803903] :
RGB::SlateBlueDark 	:= [0.282403,0.239204,0.545106] :
RGB::SlateBlueLight 	:= [0.517594,0.439207,1.0] :
RGB::SlateBlueMedium 	:= [0.482406,0.407804,0.933302] :
RGB::SlateGray 		:= [0.439207,0.501999,0.564699] :
RGB::SlateGrayDark 	:= [0.184301,0.309793,0.309793] :
RGB::SlateGrayLight 	:= [0.466704,0.533296,0.599994] :
RGB::Smoke 		:= [0.960799,0.960799,0.960799] :
RGB::Snow 		:= [1.0,0.980407,0.980407] :
RGB::SpringGreen 	:= [0.0,1.0,0.498001] :
RGB::SpringGreenMedium 	:= [0.0,0.980407,0.6039] :
RGB::SteelBlue 		:= [0.274499,0.509796,0.705893] :
RGB::SteelBlueLight 	:= [0.690207,0.768593,0.870602] :
RGB::TerreVerte 	:= [0.219993,0.370006,0.059999] :
RGB::Thistle 		:= [0.847102,0.749,0.847102] :
RGB::Titanium 		:= [0.990005,1.0,0.940001] :
RGB::Tomato 		:= [1.0,0.388195,0.278405] :
RGB::Turquoise 		:= [0.250999,0.878399,0.815699] :
RGB::TurquoiseBlue 	:= [0.0,0.780007,0.550005] :
RGB::TurquoiseDark 	:= [0.0,0.807794,0.819605] :
RGB::TurquoiseMedium 	:= [0.282403,0.819605,0.799997] :
RGB::TurquoisePale 	:= [0.6863,0.933302,0.933302] :
RGB::Ultramarine 	:= [0.069994,0.039995,0.559999] :
RGB::UltramarineViolet 	:= [0.359996,0.140004,0.430006] :
RGB::VanDykeBrown 	:= [0.370006,0.149998,0.020005] :
RGB::VenetianRed 	:= [0.829997,0.099994,0.119999] :
RGB::Violet 		:= [0.559999,0.370006,0.599994] :
RGB::VioletDark 	:= [0.580401,0.0,0.827494] :
RGB::VioletRed 		:= [0.815699,0.125507,0.564699] :
RGB::VioletRedMedium 	:= [0.780404,0.0824,0.521607] :
RGB::VioletRedPale 	:= [0.858806,0.439207,0.576495] :
RGB::ViridianLight 	:= [0.430006,1.0,0.440001] :
RGB::WarmGray 		:= [0.5,0.5,0.410001] :
RGB::Wheat 		:= [0.960799,0.870602,0.702002] :
RGB::White 		:= [1.0,1.0,1.0] :
RGB::Yellow 		:= [1.0,1.0,0.0] :
RGB::YellowBrown	:= [0.86, 0.58, 0.44] :
RGB::YellowGreen 	:= [0.6039,0.803903,0.196097] :
RGB::YellowLight 	:= [1.0,1.0,0.878399] :
RGB::YellowOchre 	:= [0.889996,0.509995,0.089999] :
RGB::Zinc 		:= [0.990005,0.97,1.0] :

RGB::interface := { ColorNames, op(RGB::ColorNames()) }:
