#
| plotlib::cylindricalplot - generates graphics in cylindrical coordinates
|
| args                     - <scene_options ,> object_1 <, object_2, ...>
|
|                          Hereby the <scene_options> describes the options
|                          which can be set in order to influence the whole
|                          graphics (like Scaling). These options are optio-
|                          nal. All options listed in the reference manual
|                          can be used here.
|
|                          object_i is used to specify the i-th object of
|                          the current graphics. This is to be given in form
|                          of a list:
|
|                          [[r, phi, z], phi = [pmin, pmax], z = [zmin, zmax], 
|                            options]
|
|                          r       - radius
|                          phi     - angle
|                          z       - describes the z-coordinates
|                          pmin    - minimum value for the range in which phi
|                                    is evaluated
|                          pmax    - maximum value for the range in which phi
|                                    is evaluated
|                          zmin    - minimum value for the range in which z 
|                                    is evaluated
|                          zmax    - maximum value for the range in which z
|                                    is evaluated
|                          options - used to influence the graphical represen-
|                                    tation of the object. All options listed
|                                    for plot3d() in the reference manual can
|                                    be used here.
#
plotlib::cylindricalplot := proc()
    local i, j, list, fsin, fcos;
begin
    fsin := funcattr(sin, "float"):
    fcos := funcattr(cos, "float"):

    if args(0) = 0 then 
        plot(Dimension = 3)
    else 
        for i from 1 to args(0) do 
            list[i]:=args(i); 
            if 2 <= nops(op(list[i], 1)) then 
                list[i]:=subsop(list[i], [1] = 
                                (Mode = Surface,
                                 [op(list[i],[1,1])*fsin(op(list[i],[1,2])),
                                  op(list[i],[1,1])*fcos(op(list[i],[1,2])),
                                  op(list[i],[1,3])])):
            end_if; 
        end_for; 
        plot3d(list[j] $ j = 1..nops(list)):
    end_if:
end_proc:
