# $Date: 1994/05/31 13:23:40 $  $Author: linus $  $Revision: 1.1 $ # 

#++
jacobi(n, a,b, x) - generates the nth Jacobi polynomial
++#

#--
Jacobi(n, a, b, x) - recurrence relation for Jacobi polynomials
--#

#--
computing Jacobi polynomial J(n,x) by using the recurrence relation
J(0,a,b,x) = 1
J(1,a,b,x) = (a/2-b/2) + (1+a/2+b/2)*x
J(n,a,b,x) = ((2*n+a+b-1)*((2*n-2+a+b)*(2*n+a+b)*x+a^2-b^2)*J(n-1,a,b,x) -
                                2*(n-1+a)*(n-1+b)*(2*n+a+b)*J(n-2,a,b,x)) / (2*n*(n+a+b)*(2*n-2+a+b)) for n > 1 .
--#
orthpoly::jacobi := proc(n,a,b,x)
local T;
begin
	if args(0) <> 4
                then
                        error("wrong number of arguments!");
        end_if;

	if not (domtype(n) = DOM_INT)
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;

	if not (domtype(a) = DOM_INT) and not (domtype(a) = DOM_RAT)
		then
			error("2nd argument must be a rational number!");
	end_if;
	
	if not (domtype(b) = DOM_INT) and not (domtype(b) = DOM_RAT)
		then
			error("3rd argument must be a rational number!");
	end_if;

	if a <= -1 or b <= -1 
		then
			error("2nd and 3rd argument must be greater than -1");
	end_if;

	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Jacobi(n,a,b,x), [x], Expr);
		else
			poly(orthpoly::Jacobi(n,a,b,T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
the recursive part for the Jacobi polynomials.
the result is an expression, not a polynomial

orthpoly::Jacobi := proc(n,a,b,x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := (a/2-b/2) + (1+a/2+b/2)*x;
			break;
		otherwise
			T :=   ((2*n+a+b-1)*((2*n-2+a+b)*(2*n+a+b)*x+a^2-b^2)*orthpoly::Jacobi(n-1,a,b,x) -
				2*(n-1+a)*(n-1+b)*(2*n+a+b)*orthpoly::Jacobi(n-2,a,b,x)) / (2*n*(n+a+b)*(2*n-2+a+b));

	end_case;
	T;
end_proc:
--#

#--
iterative version of computing  Jacobi polynomials.
the result is an expression, not a polynomial
--#
orthpoly::Jacobi := proc(n,a,b,x)
local T, i;
begin
        case n
           of 0 do
                T := 1;
                break;
           of 1 do
                T := (a/2-b/2) + (1+a/2+b/2)*x;
                break;
           otherwise
                1; (a/2-b/2) + (1+a/2+b/2)*x;
                for i from 1 to n-1 do
			expand(((2*i+1+a+b)*((2*i+a+b)*(2*i+2+a+b)*x+a^2-b^2)*eval(%1) - 2*(i+a)*(i+b)*(2*i+2+a+b)*eval(%2)) / (2*(i+1)*(i+1+a+b)*(2*i+a+b)));
                end_for;
                T := %;
        end_case;
        T
end_proc:
