#
curtz(n,x) generates the n-th Curtz polynomial in x

P_0 = 1
P_n = x*sum((-1)^q/(q+1)*P_{n-q-1},q=0..n-1)+(-1)^n/(n+1)
#

orthpoly::curtz := proc(n,x) local q;
option remember;
begin
   if n=0 then 1
   elif testtype(n,Type::PosInt) then
      expand(x*_plus((-1)^q/(q+1)*orthpoly::curtz(n-q-1,x) $ q=0..n-1))+(-1)^n/(n+1)
   else error("first argument should be a nonnegative integer")
   end_if
end_proc:
