# ode::undet(l,x) returns a list of polynomial solutions of the ODE
  l[1]*y(x)+l[2]*diff(y(x),x)+...+l[n+1]*diff(y(x),x$n)=0
  using the method of undetermined coefficients (Zwillinger chap. 84 p. 309)

  Input: l is a list, x is a variable
  Output: FAIL or a list of solutions

  Example: ode::undet([4*x-2,-2*x^2+1,x^2-x],x); returns [C1*x^2]
           which is a polynomial solution of the equation
           (4*x-2)*y(x)+(-2*x^2+1)*diff(y(x),x)+(x^2-x)*diff(y(x),x,x)=0

           ode::undet([0,1,x],x); returns [C2]
#
ode::undet := proc(l,x)
local n,i,m,f,eq,s,p,sol;
begin
   userinfo(1,"trying to find a polynomial solution by undeterminate coefficients");
   n:=nops(l)-1; # order of the equation #
   # tries to find a polynomial solution of leading term a*x^m #
   f:=1; eq:=0;
   for i from 0 to n do
      # diff(x^m,x$i) = m*(m-1)*...*(m-i+1)*x^(m-i) #
      eq:=eq+lmonomial(l[i+1],[x])*f*x^(n-i);
      f:=f*(m-i);
   end_for;
   eq:=lcoeff(eq,[x]);
   userinfo(2,"equation for the degree m is",eq);
   if indets(eq)<>{m} then return(FAIL) end_if;
   loadlib("sharelib");
   s:=sharelib::iroots(eq,FALSE);
   if s={} then return(FAIL) end_if;
   userinfo(2,"possible degrees are",op(s));
   sol:=[];
   for m in s do # try degree m #
      if m<0 then next
      elif m=0 then
         if l[1]=0 then sol:=append(sol,genident("C")) end_if; next
      end_if;
      p:=NIL;
      f:=_plus(p[i]*x^i $ hold(i)=0..m-1)+x^m; # monic #
      eq:=_plus(l[i+1]*diff(f,x$i) $ hold(i)=0..n);
      eq:=linsolve({coeff(eq,[x])},{p[i]$hold(i)=0..m-1});
      if eq=null() then next end_if;
      f:=subs(f,op(eq));
      sol:=append(sol,genident("C")*f)
   end_for;
   if sol=[] then FAIL else sol end_if
end_proc:
