ode::solve_sys := proc(sys,unks) # unks is a set #
local is_linear,eq,inits,l,y,z,ord,maxord,s,i,j,A,ll,b,m,k,sol,n;
begin
   l:={}; z:={};
   for eq in unks do
      if type(eq)="function" then
         if type((y:=op(eq,0)))=DOM_IDENT and nops(eq)=1 then
            l:=l union {y};
            z:=z union {op(eq)};
            next
         end_if
      end_if;
      error("invalid unknown function")
   end_for;
   if nops(z)<>1 then error("wrong number of independent variables") end_if;
   z:=op(z);
   n:=nops(l); # number of unknowns functions #
   # first split equations and initial conditions #
   eq:=ode::split(sys,z);
   sys:=eq[1]; inits:=eq[2];
   if nops(sys)<>n then error("number of equations differs from number of unknowns") end_if;
   # check the equations and compute the maximal order #
   maxord:=0;
   for eq in sys do
      if not testtype(eq,Type::ODE(l,z)) then
         error("not a system of ordinary differential equations in the given variables")
      end_if;
      s:=ode::indets(eq,l);
      ord:=max(op(map(s,ode::order)));
      maxord:=max(ord,maxord);
   end_for;
   userinfo(1,"differential system of order",maxord,"with",n,"functions");
   # recognize linear systems #
   s:=[(diff(op(l,i)(z),z$j) $ i=1..n) $ j=0..maxord];
   m:=n*(maxord+1);
   is_linear:=TRUE; b:=[];
   for k from 0 to maxord do A[k]:=[[0$n]$n] end_for;
   for i from 1 to n do
      eq:=op(sys,i);
      if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
      if (ll:=Type::Linear(eq,s))<>FALSE then
         b:=append(b,ll[m+1]);
         for k from 0 to maxord do
            for j from 1 to n do A[k][i][j]:=ll[k*n+j] end_for;
         end_for;
      else is_linear:=FALSE; break
      end_if
   end_for;
   sol:=FAIL;
   if is_linear then sol:=ode::linsys(A,b,l,z,n,maxord)
   else
      userinfo(1,"nonlinear system");
   end_if;
   if sol=FAIL then hold(solve)(args()) else [sol] end_if
end_proc:
