# ode::separate(eq,y,z,n) tries to solve the n-th order equation eq=0 for y(z)
  either recognizing a direct n-th order equation (D@@n)(y)(x)=f(x)
  or separate equations

  Examples: ode::separate(diff(y(x),x,x)-exp(x),y,x,2);
            ode::separate(diff(y(x),x)+y(x)^2,y,x,1);
#

ode::separate := proc(eq,y,z,n)
local s,yp,i,l,inty;
begin
   # first try to recognize (D@@n)(y)(x)=f(x) #
   # cf Zwillinger page 147 #
   s:=subs(eq,diff(y(z),z$n)=yp);
   s:=solve(s,yp);
   if nops(s)=1 then
      s:=op(s);
      if not has(s,{y,FAIL}) then # try to integrate directly #
	 userinfo(1,"trivial n-th order equation");
	 for i from 1 to n do
	    userinfo(2,"integrand is",s);
	    s:=int(s,z)+genident("C");
	 end_for;
	 return([s])
      elif n=1 and type(s)="_mult" then # try to separate #
	 l:=select(s,has,y);
	 s:=s/l;
	 l:=subs(l,y(z)=y);
	 if not has(l,z) then # int(dy/l)=int(s,z) #
	    userinfo(2,"separate equation:",diff(y(z),z)/l=s);
            inty:=int(1/l,y);
            if type(inty)="ln" then # incorparate the constant in the logarithm #
               s:=op(inty)=genident("C")*exp(int(s,z))
            else s:=inty=int(s,z)+genident("C")
            end_if;
            s:=solve(s,y);
	    userinfo(2,"solution is",s);
	    return(s);
	 end_if
      end_if
   end_if;
   FAIL
end_proc:
