# ode::firstord(eq,y,x) recognizes and solves 
  the first-order linear homogeneous differential equation eq=0
  in y(x) by direct integration.

  Output: either a solution or FAIL

  Example: ode::firstord(x^2*diff(y(x),x)+3*x*y(x),y,x);
#

ode::firstord := proc(eq,y,x)
local yp,f;
begin
   # recognizes equations of the form a(x)*diff(y(x),x)+b(x)*y(x)=0 #
   f:=subs(eq,diff(y(x),x)=yp);
   f:=normal(-coeff(f,yp,0)/coeff(f,yp,1)/y(x));
   if not has(f,y) then # try to integrate y'/y = f #
      userinfo(1,"first-order linear homogeneous differential equation");
      expand(exp(int(f,x)))
   else FAIL
   end_if;
end_proc:
