# Friedrich Schwarz 11.3.1994 #

#--
sigma(a)   - returns the sum of the positive divisors of a
sigma(a,k) - returns the sum of the kth powers of the
             positive divisors of a
a - non-zero integer
k - non-negative integer

sigma(a) is the same as sigma(a,1) and as sumdivisors(a)
sigma(a,0) is the same as tau(a) and as numdivisors(a)

sigma uses ifactor
--#

numlib::sigma := proc()
  local a, k, i, w;
begin
  if args(0) = 1 then
    a := args(1);
    k := 1;
  elif args(0) = 2 then
    a := args(1);
    k := args(2)
  end_if;

  if testargs() then
    if args(0) = 0 or args(0) > 2 then
      error("wrong number of arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(k,NUMERIC) then
	    return(procname(args()))
	  elif domtype(a) <> DOM_INT then
      if args(0) = 1 then
	      error("argument must be an integer")
      else
        error("1st argument must be an integer")
      end_if;
    elif domtype(k) <> DOM_INT or k < 0 then
      error("2nd argument must be a non-negative integer")
	  end_if
  end_if;
  
  if a = 0 or k = 0 then
    numlib::numdivisors(a)
  else
    w := ifactor(a);
    _mult((w[2*i]^(k*(w[2*i+1] + 1)) - 1)/(w[2*i]^k - 1) $ hold(i) = 1..(nops(w)-1)/2)
  end_if
end_proc:

