# Friedrich Schwarz 14.9.1994 #

#--
primroot(m)   - returns the least positive primroot modulo m
primroot(a,m) - returns the least primroot modulo m
                which is >= a
m - a natural number
a - an integer

method: brute force

primroot uses ifactor
--#

numlib::primroot := proc()
  local m, a, n, primedivs, r, g, i, q;
begin
  if args(0) = 1 then
    a := 1;
    m := args(1)
  elif args(0) = 2 then
    a := args(1);
    m := args(2)
  end_if;
  if testargs() then
    if args(0) = 0 or args(0) > 2 then
      error("wrong number of arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(m,NUMERIC) then
	    return(procname(args()))
	  elif args(0) = 1 then
	    if domtype(m) <> DOM_INT or m < 1 then
	      error("argument must be a natural number")
	    end_if
	  else
	    if domtype(a) <> DOM_INT then
	      error("1st argument must be an integer")
      elif domtype(m) <> DOM_INT or m < 1 then
        error("2nd argument must be a natural number")
	    end_if
	  end_if
  end_if;

  if m = 1 then
    return(a)
  elif m = 2 then
    return(a + modp(a + 1,2))
  elif m = 4 then
    return(m*(a div m) + 3)
  end_if;
  if modp(m,4) = 0 then
    return(FAIL)
  else
    numlib::numprimedivisors(m);
    if % > 2 or (% = 2 and modp(m,2) = 1) then
      return(FAIL)
    else
      n := phi(m);
      primedivs := numlib::primedivisors(n);
      r := nops(%);
      for g from a to a + m do
        if igcd(g,m) = 1 then
          i := 1;
          for q in primedivs do
            if powermod(g,n/q,m) = 1 then
              break
            else
                i := i+1
            end_if
          end_for;
          if i > r then
            return(g)
          end_if
        end_if
      end_for
    end_if
  end_if
end_proc:

