# Friedrich Schwarz 10.9.1994 #

#--
lincongruence - returns the list of all integers x such that
a*x = b (mod m) and 0 <= x < m
a, b - integers
m - natural number
--#

numlib::lincongruence := proc(a,b,m)
local d, i;
begin
  if testargs() then
    if args(0) <> 3 then
      error("expected three arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(b,NUMERIC) or 
         not testtype(m,NUMERIC) then
	  return(procname(args()))
	  elif domtype(a) <> DOM_INT or domtype(b) <> DOM_INT then
	    error("1st and 2nd argument must be integers")
    elif domtype(m) <> DOM_INT or m = 0 then
      error("3rd argument must be a non-zero integer")  
	  end_if
  end_if;
  
  d := igcd(a,m);
  if modp(b,d) <> 0 then
	  return(FAIL)
  else
	  modp(modp(1/(a/d),m/d) * b/d,m/d);
	  return(sort([% + i*(m/d) $ i = 0..d-1]))
  end_if
end_proc:
