# Friedrich Schwarz 28.3.1994, 8.3.1995 #

#--
jacobi(a,m) - returns the Jacobi symbol (a | m)
a - integer
m - odd natural number

jacobi uses the "ordinary algorithm", see
J. Shallit, On the worst case of three algorithms for computing
the Jacobi symbol. J. Symbolic Comp. 10 (1990) 593 - 610
--#

numlib::jacobi := proc(a,m)
  local x, y, z, symb;
begin
  if testargs() then
    if args(0) <> 2 then
     error("expected two arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(m,NUMERIC) then
     return(procname(args()))
   elif domtype(a) <> DOM_INT then
     error("1st argument must be an integer")
   elif domtype(m) <> DOM_INT or m < 1 or modp(m,2) = 0 then
     error("2nd argument must be an odd natural number")
   end_if
  end_if;
     
  if igcd(a,m) <> 1 then
    return(0)
  end_if;
  x := modp(a,m);
  y := m;
  symb := 1;
  while x > 1 do
     while modp(x,4) = 0 do
    x := x/4
   end_while;
 if modp(x,2) = 0 then
      x := x/2;
      if  modp(y + 2,8) > 4 then
     symb := -symb
   end_if;
     end_if;
   if (modp(x,4) = 3 and modp(y,4) = 3) then
     symb := -symb
   end_if;
   z := modp(y,x);
   y := x;
   x := z
   end_while;
   return(symb)
end_proc:
