# Friedrich Schwarz 28.3.1994 #

#--
isquadres(a,m) - checks if a is a quadratic residue modulo m
a - integer
m - natural number

isquadres uses ifactor and numlib:jacobi
--#

numlib::isquadres := proc(a,m)
  local n, r, p;

begin
  if testargs() then
    if args(0) <> 2 then
	    error("expected two arguments in function call")
    elif not testtype(a,NUMERIC) or not testtype(m,NUMERIC) then
	    return(procname(args()))
	  elif domtype(a) <> DOM_INT then
	    error("1st argument must be an integer")
	  elif domtype(m) <> DOM_INT or m < 1 then
	    error("2nd argument must be a natural number")
	  elif igcd(a,m) > 1 then
	    error("arguments must be relative prime")
	  end_if
  end_if;
  
  if m = 1 then 
    return(TRUE)
  end_if;
  if numlib::issqr(a) then
    return(TRUE)
  end_if;
  n := m;
  if modp(n,2) = 0 then
    r := 0;
    repeat
      n := n div 2;
	    r := r + 1
	  until modp(n,2) = 1
    end_repeat;
    if r > 2 then
      if modp(a,8) <> 1 then
	      return(FALSE)
	    end_if
    elif r = 2 then
      if modp(a,4) <> 1 then
	      return(FALSE)
	    end_if
    end_if
  end_if;
  if numlib::jacobi(a,n) = -1 then
    return(FALSE)
  elif numlib::issqr(modp(a,n)) then
    return(TRUE)
  else
    for p in numlib::primedivisors(n) do
      if numlib::jacobi(a,p) = -1 then
	      return(FALSE)
	    end_if
    end_for
  end_if;
  return(TRUE)
end_proc:

