# Friedrich Schwarz 15.9.1994 #

#-----
regularHensel(Q,a,p,alpha,c) (to be used in mrootsPP) :
input:
Q     -- a univariate polynomial over the integers
p     -- a prime number
alpha -- a natural number
a     -- an integer such that Q(a) = 0 (mod p)
         and Q'(a) <> 0 (mod p)
c     -- c := Q'(a) mod p <> 0
output:
the unique integer b in {0,1,..,p^alpha - 1} such
that Q(b) = 0 (mod p^alpha) and b = a (mod p)

singularHensel(Q,a,p,alpha) (to be used in mrootsPP) :
input:
Q     -- a univariate polynomial over the integers
p     -- a prime number
alpha -- a natural number
a     -- the list of integers y in {0,1,..,p - 1} 
         such that Q(y) = 0 (mod p) and Q'(y) = 0 (mod p)
output:
the list of all integers z in {0,1,..,p^alpha - 1} such
that Q(y) = 0 (mod p^alpha) and z = y (mod p) for an
entry y in the list a

Both algorithms use an appropiate form of Hensel's lemma
-----#

numlib::regularHensel := proc(Q,a,p,alpha,c)
  local b, d, beta;
begin
  b := a;
  d := modp(1/c,p);
  for beta from 1 to alpha - 1 do
	  b := modp(b - Q(b)*d,p^(beta + 1))
  end_for;
  b
end_proc:

numlib::singularHensel := proc(Q,a,p,alpha)
  local b, beta, n, i, z, temp;
begin
  b := a;
  for beta from 1 to alpha - 1 do
    n := nops(b);
	for i from 1 to n do
	  z := b[i];
	  if modp(Q(z),p^(beta+1)) = 0 then
	    temp[i] := [modp(z + j*p^beta,p^(beta+1)) $ hold(j) = 0..p-1]
	  else
	    temp[i] := []
	  end_if;
	end_for;
	b := _concat(temp[i] $ hold(i) = 1..n);
    if nops(b) = 0 
      then break 
    end_if
  end_for;
  b
end_proc:
