# Friedrich Schwarz 28.3.1994 #

#--
fibonacci(n) returns the nth Fibonacci number F_n
n - non-negative integer

fibonacci uses the following recursions: 
If n is an natural number then
F_{2n}   = F_n * (F_n + 2*F_{n-1}) and
F_{2n+1} = F_{n+1}^2 + F_n^2.

The algorithm simulates the intelligent calculation 
of powers [as used in the function powermod].
--#

numlib::fibonacci := proc(n)
  local i, q, e, f, F, temp;
begin
  if testargs() then
    if args(0) <> 1 then
      error("expected one argument in function call")
    elif not testtype(n,NUMERIC) then
	    return(procname(args()))
    elif domtype(n) <> DOM_INT or n < 0 then
	    error("argument must be a non-negative integer")
	  end_if
  end_if;
  
  if n < 2
    then return(n)
  end_if;
  i := 0;
  q := n;
  while q > 1 do
    e[i] := modp(q,2);
	  q := q div 2;
	  i := i + 1
  end_while;
  f := 0;
  F := 1;
  for i from nops(e) - 1 downto 0 do
	  temp := f^2 + F^2;
	  F := F*(F + 2*f);
	  f := temp;
	  if e[i] = 1 then
	    temp := f + F;
	    f := F;
	    F := temp
	  end_if
  end_for;
  return(F)
end_proc:
