# Friedrich Schwarz 11.3.1994 #

#--
divisors(a) - returns the list of divisors of a
a - a non-zero integer

divisors uses ifactor
--#

numlib::divisors := proc(a)
  local makeProducts, w, result, i, j;
begin
  if testargs() then
    if args(0) <> 1 then
      error("expected one argument in function call")
    elif not testtype(a,NUMERIC) then
	    return(procname(args()))
    elif domtype(a) <> DOM_INT then
	    error("argument must be an integer")
	  end_if
  end_if;
  
  makeProducts := proc(a,b)
  begin 
    map(a, proc(x,y) begin op(map(y,_mult,x)) end_proc,b)
  end_proc;
  
  if a = 0 then
    [0]
  else  
    w := ifactor(a);
    result := [1];
    for i from 1 to (nops(w)-1)/2 do
      [op(w,2*i)^j $ j = 1..op(w,2*i+1)];
      result := append(result,op(makeProducts(%,result)));
    end_for;
    sort(result)
  end_if
end_proc:


