#-
 ShortPath - shortest pathes from one single node
 ShortPath(G,v)
 ShortPath(G,v,w)
 ShortPath(G,v,<Path>, <Length>)
 ShortPath(G,v,w,<Path>, <Length>)
 Parameters:
   G - Network
   v,w - node of the network G
   Path, Length - keywords

 ShortPath(G,v) returns a table with the length of shortest pathes from 
 v to all other nodes in the network. ShortPath(G,v,w) gives the length 
 of a shortest path from v to w. Uses Network::dijkstra (if there are 
 only non-negative edge weights) and Network::bellman (if there are 
 negative edge weights).  If the optional argument Path is given, then 
 a table with shortest pathes are returned. If Length and Path are given, 
 then both the length of the shortest pathes and the pathes are returned.
-#
Network::ShortPath := proc(G,v)
local d,www,ww,V,Ew,Epo,a;
begin
   if testargs() then
      if args(0) < 2 or args(0) > 5 then
	     error("Wrong number of arguments!");
      end_if;
      Network::graph_check(G);
   end_if;

   T := Network::spath_arg_check(args());
   a := T[1];
   ww := T[2];
   www := T[3];

   V := Network::Vertex(G);
   Epo := Network::Epost(G);
   Ew := Network::EWeight(G);

   if min(op(Ew, [1..nops(Ew),2])) < 0 then
      d := Network::bellman(V, Epo, Ew, v);
   else
      d := Network::dijkstra(V, Epo, Ew, v);
   end_if;

   Network::spath_eval(V,d,a,ww,www,0);
end_proc:
