#-
  pp_fifo - computes maximal flow
  FIFO-Preflow-Push-Algorithm of Goldberg&Tarjan.
  "A new approach to the maximum-flow problem", Journal ACM 35(4), 1988
  Running time: O(n^3)
  Uses an exact distance labelling.
-#
Network::pp_fifo := proc(V, Ed, Ecap, Epo, Epr, q, s)
local Vd,d,inflow,outflow,preflow,i,j,sum,Q,relabel,dist_sink,schritt;
begin

relabel := proc(v, flow, d, Ecap, Epo, Epr)
local i,e,mini;
begin
mini := 3 * nops(Epo); #- Upper bound for distance labels: 3 * |V| -#
for i in Epo[v] do 
	e := [v,i];
	if Ecap[e]-flow[e] > 0 and d[v] <= d[i] then
		mini := min(mini, d[i]+1);
	end_if;
end_for;
for i in Epr[v] do 
	e := [i,v];
	if flow[e] > 0 and d[v] <= d[i] then
		mini := min(mini, d[i]+1);
	end_if;
end_for;
d[v] := mini;
d;
end_proc:

#--
 dist_sink - Berechnet den Abstand der Knoten zur Senke
 Es werden die k"urzesten Wege von der Senke s zu allen "ubrigen Knoten
 im Netzwerk berechnet. Das Ergebnis ist eine Tabelle d, mit
        d[v] = L"ange des k"urzesten Weges von v nach s
--#
dist_sink := proc(V,Ecap,Epr,s)
local d,j,LIST,i,n;
begin
n := nops(V);
d := table(V[i] = n $ i=1..nops(V));
d[s] := 0;
LIST := [s];
while LIST <> [] do
    i := LIST[1];
    LIST[1] := NIL;
    for j in Epr[i] do
        if d[j] > d[i] + 1 then
            d[j] := d[i] + 1;
            if contains(LIST, j) = 0 then
                LIST := append(LIST, j);
            end_if;
        end_if;
    end_for;
end_while;
d;
end_proc:


schritt := proc(Q)
local i,j,e,f,PP,v,abgabe;
begin
for i in Q do
	PP := inflow[i] - outflow[i];
	j := 1;
	v := op(Epo[i],j);
	#--
	 Abgabe an Nachfolgeknoten
	--#
	while v <> FAIL and 0 < PP do
		e := [i,v];
		if d[i] = d[v]+1 then
			abgabe := max(min(Ecap[e] - preflow[e], PP), 0);
			preflow[e] := preflow[e] + abgabe;
			PP := PP-abgabe; 
			outflow[i] := outflow[i] + abgabe;
			inflow[v] := inflow[v] + abgabe;
		end_if;
		j := j+1;
		v := op(Epo[i],j);
	end_while;
	j := 1;
	v := op(Epr[i],j);
	#--
	 Rueckgabe an Vorg"angerknoten
	--#
	while v <> FAIL and 0 < PP do 
		e := [v,i];
		if d[i] = d[v]+1 then
			abgabe := max(min(preflow[e], PP),0);
			preflow[e] := preflow[e] - abgabe;
			PP := PP - abgabe;
			inflow[i] := inflow[i] - abgabe;
			outflow[v] := outflow[v] - abgabe;
		end_if;
		j := j+1;
		v := op(Epr[i],j);
	end_while;
	if PP > 0 then 
		#- 
		 Es konnte nicht der ganze "Uberschu"s verteilt werden -> Relabel
		-#
		d := relabel(i, preflow, d, Ecap, Epo, Epr); 
	end_if;
end_for;

f := fun(bool(inflow[args(1)] <> outflow[args(1)]));
Q := select(Vd, f);
end_proc:

Vd := [op({op(V)} minus {q,s})];
d := dist_sink(V,Ecap,Epr,s);
d[q] := nops(V);
d[FAIL] := 0;
preflow := table(Ed[i] = 0 $ i=1..nops(Ed));
inflow := table(V[i] = 0 $ i=1..nops(V));
outflow := inflow;
	
Q := []:
for i in Epo[q] do
	preflow[[q,i]] := Ecap[[q,i]];
	outflow[q] := outflow[q] + Ecap[[q,i]];
	inflow[i] := Ecap[[q,i]];
	Q := append(Q, i);
end_for;

Q := schritt(Q);
while Q <> [] do
	Q := schritt(Q);
end_while;

i := NIL;
sum := _plus(preflow[[Epr[s][i],s]] $ i=1..nops(Epr[s]));

sum, preflow;
end_proc:
