#-
 LongPath - longest pathes for one node
 LongPath(G,v)
 LongPath(G,v,w)
 LongPath(G,v,<Path>, <Length>)
 LongPath(G,v,w,<Path>, <Length>)
 Parameters:
   G - Network
   v,w - node of the network G
   Path, Length - keywords

 LongPath(G,v) returns a table with the length of longest pathes from 
 v to all other nodes in the network. LongPath(G,v,w) gives the length 
 of a longest path from v to w. Uses Network::lbellman. If the optional 
 argument Path is given, then a table with longest pathes are returned. 
 If Length and Path are given, then both the length of the longest pathes 
 and the pathes are returned.
-#
Network::LongPath := proc(G,v)
local d,www,ww,V,Ew,Epo,a;
begin
   
   if testargs() then
      if args(0) < 2 or args(0) > 5 then
	     error("Wrong number of arguments!");
      end_if;
      Network::graph_check(G);
   end_if;
    
   T := Network::spath_arg_check(args());
   a := T[1];
   ww := T[2];
   www := T[3];

   V := Network::Vertex(G);
   Epo := Network::Epost(G);
   Ew := Network::EWeight(G);

   d := Network::lbellman(V, Epo, Ew, v);
   Network::spath_eval(V,d,a,ww,www);
end_proc:
