 #-
 lbellman - longest path algorithm of Bellman
 "On a routing problem", Quart. Appl. Math. 16 (1958)
 Running time O(|V| |Edge|) (FIFO implementation)
 Taken from: Ahuja, Magnanti, Orlin: Network Flows, Prentice-Hall, 1993
             Section 5.4
-#
Network::lbellman := proc(V, Epo, Ew, v)
local d,j,LIST,i,C,prec,pass;
begin
C := (nops(V)+1) * max(op(Ew, [1..nops(Ew),2]));
d := table((V[i] = -infinity $ i=1..nops(V)));
d[v] := 0;
LIST := [v];
pass := table((V[i] = 0 $ i=1..nops(V)));
while LIST <> [] do
    i := LIST[1];
    LIST[1] := NIL;
    pass[i] := pass[i] + 1;
    if pass[i] > nops(V) then
	error("Network contains negative cycle!");
    end_if;
    for j in Epo[i] do
        if d[j] < d[i] + Ew[[i,j]] then
            d[j] := d[i] + Ew[[i,j]];
            prec[j] := i;
            if contains(LIST, j) = 0 then
                LIST := append(LIST, j);
            end_if;
        end_if;
    end_for;
end_while;
[d,prec];
end_proc:
