#-
 InDegree - vertex indegrees of a network
 InDegree(G)
 InDegree(G,v)
 InDegree(G, [v1,..,vn])
 Parameters:
   G - network
   v,v1,..,vn - nodes of G
-#
Network::InDegree := proc(G)
local i,d,V,Epr;
begin
   if testargs() then
      if args(0) < 1 then
	error("Wrong number of arguments!"):
      end_if;
      Network::graph_check(G);
   end_if;
   V := Network::Vertex(G);
   Epr := Network::Epre(G);
   
   case args(0)
  	of 1 do
	   return(table(V[i] = nops(Network::Epre(G)[V[i]]) $ i=1..nops(V)));
   	of 2 do
	   if contains(V, args(2)) = 0 then
		error("Network doesn't contain specified node!");
	   end_if;
   	   return(nops(Epr[args(2)]));
   	otherwise
           d := table();
 	   for i from 2 to args(0) do 
	      if contains(V, args(i)) = 0 then
		error("Network doesn't contain specified node!");
	      end_if;
	      d[args(i)] := nops(Epr[args(i)]);
	   end_for;
   	   return(d);
   end_case;
end_proc:
