#-
 DelVertex - deletes a node 
 DelVertex(G,x)
 DelVertex(G,[x1,..,xn]
 Parameters:
   G - network
   x - node, list of nodes
 Deletes all specified nodes and the incident arcs from the network.
-#
Network::DelVertex := proc(G,v)
local V,Ed,Vw,Ew,Ecap,Epo,Epr,i,f,a,b,e;
begin
  if testargs() then
    if args(0) <> 2 then
	error("Wrong number of arguments!");
    end_if;
    Network::graph_check(G);
  end_if;
  V   := Network::Vertex(G);
  Ed  := Network::Edge(G);
  Vw  := Network::VWeight(G);
  Ew := Network::EWeight(G);
  Ecap := Network::ECapacity(G);
  Epo := Network::Epost(G);
  Epr := Network::Epre(G);
  f := fun(bool(contains(args(1),args(2)) <> 0)):
  if testtype(v, DOM_LIST) then
     for i in v do
        b := contains(V, i);
	if b > 0 then
	   V[b] := NIL;
	   a := select(Ed, f, i);
	   Vw[i] := NIL;
           for e in a do 
	      b := contains(Epo[e[1]],e[2]);
	      Epo[e[1]][b] := NIL;
	      b := contains(Epr[e[2]],e[1]);
	      Epr[e[2]][b] := NIL;
 	      Ew[e] := NIL;
 	      Ecap[e] := NIL;
	      b := contains(Ed, e);
	      Ed[b] := NIL;
	   end_for;
           Epo[i] := NIL;
	   Epr[i] := NIL;
        end_if;
     end_for;
  else
     b := contains(V, v);
     if b > 0 then
	V[b] := NIL;
        a := select(Ed, f, v);
        Vw[v] := NIL;
           for e in a do 
              b := contains(Epo[e[1]],e[2]);
              Epo[e[1]][b] := NIL;
              b := contains(Epr[e[2]],e[1]);
              Epr[e[2]][b] := NIL;
              Ew[e] := NIL;
              Ecap[e] := NIL;
	      b := contains(Ed, e);
	      Ed[b] := NIL;
           end_for;
           Epo[v] := NIL;
	   Epr[v] := NIL;
      end_if;
  end_if;
  new(Network, V, Ed, Vw, Ecap, Ew, Epo, Epr);
end_proc:
