#-
 DelEdge - deletes an edge
 DelEdge(G,e)
 DelEdge(G,[e1,..,en])
 Parameters:
   G - network
   e - edge or list of edges
 Deletes the specified edge(s).
-#
Network::DelEdge := proc(G,v)
local V,Ed,Vw,Ew,Ecap,Epo,Epr,i,f,a,b,e;
begin
  if testargs() then
    if args(0) <> 2 then
	error("Wrong number of arguments!");
    end_if;
    Network::graph_check(G);
  end_if;
  V   := Network::Vertex(G);
  Ed  := Network::Edge(G);
  Vw  := Network::VWeight(G);
  Ew := Network::EWeight(G);
  Ecap := Network::ECapacity(G);
  Epo := Network::Epost(G);
  Epr := Network::Epre(G);
  if testtype(v, Type::ListOf(DOM_LIST)) then
     for e in v do
        b := contains(Ed, e);
	if b > 0 then
	   Ed[b] := NIL;
	   b := contains(Epo[e[1]],e[2]);
	   Epo[e[1]][b] := NIL;
	   b := contains(Epr[e[2]],e[1]);
	   Epr[e[2]][b] := NIL;
 	   Ew[e] := NIL;
 	   Ecap[e] := NIL;
        end_if;
     end_for;
  else
     b := contains(Ed, v);
     if b > 0 then
	Ed[b] := NIL;
        b := contains(Epo[v[1]],v[2]);
        Epo[v[1]][b] := NIL;
        b := contains(Epr[v[2]],v[1]);
        Epr[v[2]][b] := NIL;
        Ew[v] := NIL;
        Ecap[v] := NIL;
      end_if;
  end_if;
  new(Network, V, Ed, Vw, Ecap, Ew, Epo, Epr);
end_proc:
