# $Date: 1994/06/08 11:41:27 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 13.05.94 #

#++
expr2text  - Convert an expression into a string of given min.-length

expr2text( len, arg )
expr2text( arg )
expr2text( )

len - Integer
arg - Expression

If no value is given for 'len', this function works like 'expr2text'.
Otherwise:  if 'arg' is NOT a string  then it will be converted to a
string, by using 'expr2text'. If it has fewer than 'len' characters,
it will be padded (with whitespaces) on the left (or right, if 'len'
is negative) .

For more information, refer to the MuPAD online-manual: 'expr2text'.
++#

module::expr2text:= proc( len, arg )
local	prefix;
begin
	if( args(0) <= 1 ) then return( expr2text(args()) );	
	end_if;
	if( domtype(len) <> DOM_INT    ) then error( "Illegal argument" );
	end_if;
	if( domtype(arg) <> DOM_STRING ) then arg:= expr2text( arg );
	end_if;
	
	if( len < 0 ) then prefix:= TRUE ; len:= -len;
	              else prefix:= FALSE;
	end_if;
	len:= len - strlen(arg);
	
	if  ( len <= 0 ) then arg;
	elif( prefix   ) then _concat( " " $ len , arg );
	                 else _concat( arg , " " $ len );
	end_if;
end_proc:
