
misc::TestFile:= FAIL:

#++
misc::testinit -- init testing

misc::testinit([f])

f - file name (default is "test")

Opens the test result file 'f.res'.
++#

misc::testinit:= proc(f)
begin
    if args(0) = 0 then f:= "test"
    elif args(0) = 1 then
	if domtype(f) <> DOM_STRING then
	    error("illegal file name prefix")
	end_if
    else error("wrong no of args") end_if;
    misc::TestFile:= fopen(Text, f.".res", Write);
    if misc::TestFile = FAIL then
	error("could not open results file")
    end_if;
    misc::TestNo:= 1;
    misc::TestFunc:= FAIL;
    null()
end_proc:

#++
misc::testexit -- exit testing

misc::testexit()

Close test results file.
++#

misc::testexit:= proc()
begin
    fclose(misc::TestFile);
    misc::TestNo:= 0;
    misc::TestFunc:= FAIL;
    null()
end_proc:

#++
misc::testfunc -- init testing of function

misc::testfunc(f)

f - expression

misc::testfunc(f) initializes the testing of function f. The argument
is not evaluated. If the test result file has not been opened it is
opened by misc::testfunc.
++#

misc::testfunc:= proc()
    option hold;
begin
    if args(0) <> 1 then error("wrong no of args") end_if;
    if domtype(misc::TestFile) <> DOM_INT then
	misc::TestFile:= fopen(Text, "test.res", Write);
	if misc::TestFile = FAIL then
	    error("could not open test.res")
	end_if;
    end_if;
    misc::TestNo:= 1;
    misc::TestFunc:= args(1);
    null()
end_proc:

#++
misc::test -- test function

misc::test()
misc::test(a)
misc::test(a, b)

a, b - expressions

misc::test prints - depending upon the parameters - the current function
and test number onto the test results file 'test.res'. This signals
an error in the current test.

misc::test() prints the current function and test number unconditional.

misc::test(a) prints the current function and test number if a is not
equal to TRUE or if an error occures during the evaluation of a.

misc::test(a, b) prints the current function and test number if a is not
equal to b (in the sense of _equal) of if an error occures during the
evaluation of a or b.
++#

misc::test:= proc(a, b)
    option hold;
begin
    if domtype(misc::TestFile) <> DOM_INT then
	error("results file has not been opened")
    end_if;
    if misc::TestFunc = FAIL then
	error("no function to test")
    end_if;

    case args(0)
    of 0 do
	fprint(Unquoted, misc::TestFile, misc::TestFunc, misc::TestNo);
	break;
    of 1 do
	if traperror((a:= context(a))) <> 0 then
	    fprint(Unquoted, misc::TestFile, misc::TestFunc, misc::TestNo);
	elif a <> TRUE then
	    fprint(Unquoted, misc::TestFile, misc::TestFunc, misc::TestNo);
	end_if;
	break;
    of 2 do
	if traperror((a:= bool(context(a) = context(b)))) <> 0 then
	    fprint(Unquoted, misc::TestFile, misc::TestFunc, misc::TestNo);
	elif not a then
	    fprint(Unquoted, misc::TestFile, misc::TestFunc, misc::TestNo);
	end_if;
	break;
    otherwise error("wrong no of args");
    end_case;
    misc::TestNo:= misc::TestNo + 1;
    null()
end_proc:

# end of file #
