# $Date: 1995/06/15 14:31:35 $  $Author: frankp $  $Revision: 1.1 $ #
# #
# frankp, 28.10.1994 #

#++
  VectorOf.mu

        VectorOf -- returns type expression to test vectors
		    (of the linalg package)

        linalg::VectorOf(T [,n])

        T - type of coefficients
        n - dimension

        The type expression created returns TRUE if an expression is 
        a vector (an element of category MatrixCat) of dimension n over 
	the coefficient ring T.
        If 'n' is missing then the dimension dosn't matter.
        If 'T' equals to 'Type::AnyType' then the coefficient ring doesn't matter.
++#

linalg::VectorOf := proc(T)
    name linalg::VectorOf;
begin
    if testargs() then
	if args(0) < 1 or args(0) > 2 then
	    error("wrong no of args")
	end_if;
	if args(0) = 2 then
	   if not testtype( args(2),Type::PosInt ) then
		error("dimension must be a positive integer")
	    end_if
	end_if;
        if T <> Type::AnyType and T::hasProp( Rng ) <> TRUE then
            error("expected a Rng as argument")
        end_if
    end_if;

    new(Type,
        hold(VectorOf),
        proc(t,x)
            local n;
        begin
            if args(0) <> 2 then return( FALSE ) end_if;
            if x::hasProp( MatrixCat ) <> TRUE then
                return( FALSE )
            end_if;
            n := x::dimen(x);
            if op(%,1) <> 1 and op(%,2) <> 1 then return( FALSE ) end_if;
            if nops(t) = 2 then
                if max( op(n) ) <> t[2] then return( FALSE ) end_if
            end_if;
            if t[1] <> Type::AnyType and t[1] <> x::coeffRing then
                return( FALSE )
            end_if;
	    TRUE
        end_proc, [ args() ], FALSE)
end_proc:

# end of file #
