# #
# $Date: 1995/01/14 18:27:03 $  $Author: frankp $   $Revision: 1.7 $ #
# #
# frankp, 22/02/94 #

#++
  swapcol.mu

	linalg::swapCol(A,k,l)  --  swaps column k with column l of matrix A
++#

linalg::swapCol := proc(A,k,l)
    name linalg::swapCol;
    local c;
begin
    if testargs() then
	if args(0) <> 3 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not testtype( k,Type::PosInt )
	or not testtype( l,Type::PosInt )
	then
	    error("indices must be positive integers")
	end_if;
	c := op( A::dimen(A),2 );
	if k > c or l > c then
	    error("indices out of range")
	end_if
    end_if;

    A::swapCol(A,k,l)
end_proc:

# end of file #
